/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.csp.process.frames.BlockEncoder;
import io.activej.csp.process.frames.LZ4FrameFormat;
import net.jpountz.lz4.LZ4Compressor;

final class LZ4BlockEncoder
implements BlockEncoder {
    private static final boolean CHECK = Checks.isEnabled(LZ4BlockEncoder.class);
    private final LZ4Compressor compressor;
    private boolean writeHeader = true;

    LZ4BlockEncoder(LZ4Compressor compressor) {
        this.compressor = compressor;
    }

    @Override
    public void reset() {
        this.writeHeader = true;
    }

    @Override
    public ByteBuf encode(ByteBuf inputBuf) {
        int compressedLength;
        int headerSize = this.writeHeader ? LZ4FrameFormat.MAGIC_LENGTH : 0;
        this.writeHeader = false;
        int off = inputBuf.head();
        int len = inputBuf.readRemaining();
        byte[] array = inputBuf.array();
        if (CHECK) {
            Checks.checkArgument((len != 0 ? 1 : 0) != 0, (Object)"Encoding empty buf");
        }
        ByteBuf outputBuf = ByteBufPool.allocate((int)(headerSize + 8 + this.compressor.maxCompressedLength(len) + 1));
        if (headerSize != 0) {
            System.arraycopy(LZ4FrameFormat.MAGIC, 0, outputBuf.array(), 0, LZ4FrameFormat.MAGIC_LENGTH);
            outputBuf.moveTail(LZ4FrameFormat.MAGIC_LENGTH);
        }
        if ((compressedLength = this.compressor.compress(array, off, len, outputBuf.array(), headerSize + 8)) + 4 < len) {
            outputBuf.writeInt(compressedLength | Integer.MIN_VALUE);
            outputBuf.writeInt(len);
            outputBuf.moveTail(compressedLength);
        } else {
            outputBuf.writeInt(len);
            System.arraycopy(array, off, outputBuf.array(), outputBuf.tail(), len);
            outputBuf.moveTail(len);
        }
        outputBuf.put((byte)1);
        return outputBuf;
    }

    @Override
    public ByteBuf encodeEndOfStreamBlock() {
        if (!this.writeHeader) {
            return ByteBuf.wrapForReading((byte[])LZ4FrameFormat.LAST_BLOCK_BYTES);
        }
        this.writeHeader = false;
        return ByteBuf.wrapForReading((byte[])LZ4FrameFormat.MAGIC_AND_LAST_BLOCK_BYTES);
    }
}

