/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.LZ4LegacyFrameFormat;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.StreamingXXHash32;
import org.jetbrains.annotations.Nullable;

@Deprecated
final class LZ4LegacyBlockDecoder
implements BlockDecoder {
    private final LZ4FastDecompressor decompressor;
    private final StreamingXXHash32 checksum;
    private final boolean ignoreMissingEndOfStreamBlock;
    private int originalLen;
    private int compressedLen;
    private int compressionMethod;
    private int check;
    private boolean endOfStream;
    private boolean readingHeader = true;
    private final IntLeScanner intLEScanner = new IntLeScanner();

    LZ4LegacyBlockDecoder(LZ4FastDecompressor decompressor, StreamingXXHash32 checksum, boolean ignoreMissingEndOfStreamBlock) {
        this.decompressor = decompressor;
        this.checksum = checksum;
        this.ignoreMissingEndOfStreamBlock = ignoreMissingEndOfStreamBlock;
    }

    @Override
    public void reset() {
        this.endOfStream = false;
    }

    @Override
    @Nullable
    public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
        if (this.readingHeader) {
            if (!this.readHeader(bufs)) {
                return null;
            }
            this.readingHeader = false;
        }
        if (!bufs.hasRemainingBytes(this.compressedLen)) {
            return null;
        }
        this.readingHeader = true;
        if (this.endOfStream) {
            return END_OF_STREAM;
        }
        return this.decompressBody(bufs);
    }

    @Override
    public boolean ignoreMissingEndOfStreamBlock() {
        return this.ignoreMissingEndOfStreamBlock;
    }

    private boolean readHeader(ByteBufs bufs) throws MalformedDataException {
        bufs.scanBytes((index, value) -> {
            if (value != LZ4LegacyFrameFormat.MAGIC[index]) {
                throw new UnknownFormatException("Expected stream to start with bytes: " + Arrays.toString(LZ4LegacyFrameFormat.MAGIC));
            }
            return index == LZ4LegacyFrameFormat.MAGIC_LENGTH - 1;
        });
        if (!bufs.hasRemainingBytes(LZ4LegacyFrameFormat.HEADER_LENGTH)) {
            return false;
        }
        bufs.skip(LZ4LegacyFrameFormat.MAGIC_LENGTH);
        int token = bufs.getByte() & 0xFF;
        this.compressionMethod = token & 0xF0;
        int compressionLevel = 10 + (token & 0xF);
        if (this.compressionMethod != 16 && this.compressionMethod != 32) {
            throw new UnknownFormatException("Unknown compression method");
        }
        this.compressedLen = this.readInt(bufs);
        this.originalLen = this.readInt(bufs);
        this.check = this.readInt(bufs);
        if (this.originalLen > 1 << compressionLevel || this.originalLen < 0 || this.compressedLen < 0 || this.originalLen == 0 && this.compressedLen != 0 || this.originalLen != 0 && this.compressedLen == 0 || this.compressionMethod == 16 && this.originalLen != this.compressedLen) {
            throw new MalformedDataException("Malformed header");
        }
        if (this.originalLen == 0) {
            if (this.check != 0) {
                throw new MalformedDataException("Checksum in last block is not allowed");
            }
            this.endOfStream = true;
        }
        return true;
    }

    private int readInt(ByteBufs bufs) throws MalformedDataException {
        bufs.consumeBytes((ByteBufs.ByteScanner)this.intLEScanner);
        return this.intLEScanner.value;
    }

    private ByteBuf decompressBody(ByteBufs bufs) throws MalformedDataException {
        ByteBuf inputBuf = bufs.takeExactSize(this.compressedLen);
        ByteBuf outputBuf = ByteBufPool.allocate((int)this.originalLen);
        try {
            byte[] bytes = inputBuf.array();
            int off = inputBuf.head();
            outputBuf.tail(this.originalLen);
            if (this.compressionMethod == 16) {
                System.arraycopy(bytes, off, outputBuf.array(), 0, this.originalLen);
            } else {
                assert (this.compressionMethod == 32);
                try {
                    int compressedLen = this.decompressor.decompress(bytes, off, outputBuf.array(), 0, this.originalLen);
                    if (compressedLen != this.compressedLen) {
                        throw new InvalidSizeException("Actual size of decompressed data does not equal expected size of decompressed data");
                    }
                }
                catch (LZ4Exception e) {
                    throw new MalformedDataException("Failed to decompress data", (Throwable)e);
                }
            }
            this.checksum.reset();
            this.checksum.update(outputBuf.array(), 0, this.originalLen);
            if (this.checksum.getValue() != this.check) {
                throw new MalformedDataException("Checksums do not match. Received: (" + this.check + "), actual: (" + this.checksum.getValue() + ')');
            }
            ByteBuf byteBuf = outputBuf;
            return byteBuf;
        }
        catch (Exception e) {
            outputBuf.recycle();
            throw e;
        }
        finally {
            inputBuf.recycle();
        }
    }

    private static final class IntLeScanner
    implements ByteBufs.ByteScanner {
        public int value;

        private IntLeScanner() {
        }

        public boolean consume(int index, byte b) throws MalformedDataException {
            this.value = (index == 0 ? 0 : this.value >>> 8) | (b & 0xFF) << 24;
            return index == 3;
        }
    }
}

