/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.csp.process.frames.BlockEncoder;
import io.activej.csp.process.frames.LZ4LegacyFrameFormat;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.xxhash.StreamingXXHash32;

@Deprecated
final class LZ4LegacyBlockEncoder
implements BlockEncoder {
    private static final boolean CHECK = Checks.isEnabled(LZ4LegacyBlockEncoder.class);
    private static final int MIN_BLOCK_SIZE = 64;
    private static final int MAX_BLOCK_SIZE = 0x2000000;
    private final LZ4Compressor compressor;
    private final StreamingXXHash32 checksum;

    LZ4LegacyBlockEncoder(LZ4Compressor compressor, StreamingXXHash32 checksum) {
        this.compressor = compressor;
        this.checksum = checksum;
    }

    @Override
    public void reset() {
    }

    @Override
    public ByteBuf encode(ByteBuf inputBuf) {
        int compressMethod;
        int len = inputBuf.readRemaining();
        if (CHECK) {
            Checks.checkArgument((len != 0 ? 1 : 0) != 0);
        }
        int off = inputBuf.head();
        byte[] bytes = inputBuf.array();
        int compressionLevel = LZ4LegacyBlockEncoder.compressionLevel(Math.min(Math.max(len, 64), 0x2000000));
        int outputBufMaxSize = LZ4LegacyFrameFormat.HEADER_LENGTH + this.compressor.maxCompressedLength(len);
        ByteBuf outputBuf = ByteBufPool.allocate((int)outputBufMaxSize);
        outputBuf.put(LZ4LegacyFrameFormat.MAGIC);
        byte[] outputBytes = outputBuf.array();
        this.checksum.reset();
        this.checksum.update(bytes, off, len);
        int check = this.checksum.getValue();
        int compressedLength = this.compressor.compress(bytes, off, len, outputBytes, LZ4LegacyFrameFormat.HEADER_LENGTH);
        if (compressedLength >= len) {
            compressMethod = 16;
            compressedLength = len;
            System.arraycopy(bytes, off, outputBytes, LZ4LegacyFrameFormat.HEADER_LENGTH, len);
        } else {
            compressMethod = 32;
        }
        outputBytes[LZ4LegacyFrameFormat.MAGIC_LENGTH] = (byte)(compressMethod | compressionLevel);
        LZ4LegacyBlockEncoder.writeIntLE(compressedLength, outputBytes, LZ4LegacyFrameFormat.MAGIC_LENGTH + 1);
        LZ4LegacyBlockEncoder.writeIntLE(len, outputBytes, LZ4LegacyFrameFormat.MAGIC_LENGTH + 5);
        LZ4LegacyBlockEncoder.writeIntLE(check, outputBytes, LZ4LegacyFrameFormat.MAGIC_LENGTH + 9);
        outputBuf.tail(LZ4LegacyFrameFormat.HEADER_LENGTH + compressedLength);
        return outputBuf;
    }

    @Override
    public ByteBuf encodeEndOfStreamBlock() {
        return ByteBuf.wrapForReading((byte[])LZ4LegacyFrameFormat.MAGIC_AND_LAST_BYTES);
    }

    private static int compressionLevel(int blockSize) {
        int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
        if (CHECK) {
            Checks.checkArgument((1 << compressionLevel >= blockSize ? 1 : 0) != 0);
            Checks.checkArgument((blockSize * 2 > 1 << compressionLevel ? 1 : 0) != 0);
        }
        compressionLevel = Math.max(0, compressionLevel - 10);
        if (CHECK) {
            Checks.checkArgument((compressionLevel <= 15 ? 1 : 0) != 0);
        }
        return compressionLevel;
    }

    private static void writeIntLE(int i, byte[] buf, int off) {
        buf[off++] = (byte)i;
        buf[off++] = (byte)(i >>> 8);
        buf[off++] = (byte)(i >>> 16);
        buf[off] = (byte)(i >>> 24);
    }
}

