/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.common.Checks;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.BlockEncoder;
import io.activej.csp.process.frames.FrameFormat;
import io.activej.csp.process.frames.LZ4LegacyBlockDecoder;
import io.activej.csp.process.frames.LZ4LegacyBlockEncoder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;

@Deprecated
public final class LZ4LegacyFrameFormat
implements FrameFormat {
    static final byte[] MAGIC = new byte[]{76, 90, 52, 66, 108, 111, 99, 107};
    static final byte[] LAST_BYTES;
    static final byte[] MAGIC_AND_LAST_BYTES;
    static final int MAGIC_LENGTH;
    static final int COMPRESSION_LEVEL_BASE = 10;
    static final int COMPRESSION_METHOD_RAW = 16;
    static final int COMPRESSION_METHOD_LZ4 = 32;
    static final int HEADER_LENGTH;
    static final int DEFAULT_SEED = -1756908916;
    private final LZ4Factory lz4Factory;
    private final XXHashFactory hashFactory;
    private int compressionLevel;
    private boolean ignoreMissingEndOfStreamBlock;

    private LZ4LegacyFrameFormat(LZ4Factory factory, XXHashFactory hashFactory) {
        this.lz4Factory = factory;
        this.hashFactory = hashFactory;
    }

    public static LZ4LegacyFrameFormat create() {
        return new LZ4LegacyFrameFormat(LZ4Factory.fastestInstance(), XXHashFactory.fastestInstance());
    }

    public static LZ4LegacyFrameFormat create(LZ4Factory lz4Factory, XXHashFactory hashFactory) {
        return new LZ4LegacyFrameFormat(lz4Factory, hashFactory);
    }

    public LZ4LegacyFrameFormat withHighCompression() {
        this.compressionLevel = -1;
        return this;
    }

    public LZ4LegacyFrameFormat withCompressionLevel(int compressionLevel) {
        Checks.checkArgument((compressionLevel >= -1 ? 1 : 0) != 0);
        this.compressionLevel = compressionLevel;
        return this;
    }

    public LZ4LegacyFrameFormat withIgnoreMissingEndOfStream(boolean ignore) {
        this.ignoreMissingEndOfStreamBlock = ignore;
        return this;
    }

    @Override
    public BlockEncoder createEncoder() {
        LZ4Compressor compressor = this.compressionLevel == 0 ? this.lz4Factory.fastCompressor() : (this.compressionLevel == -1 ? this.lz4Factory.highCompressor() : this.lz4Factory.highCompressor(this.compressionLevel));
        return new LZ4LegacyBlockEncoder(compressor, this.hashFactory.newStreamingHash32(-1756908916));
    }

    @Override
    public BlockDecoder createDecoder() {
        return new LZ4LegacyBlockDecoder(this.lz4Factory.fastDecompressor(), this.hashFactory.newStreamingHash32(-1756908916), this.ignoreMissingEndOfStreamBlock);
    }

    static {
        MAGIC_LENGTH = MAGIC.length;
        LAST_BYTES = new byte[13];
        LZ4LegacyFrameFormat.LAST_BYTES[0] = 16;
        MAGIC_AND_LAST_BYTES = new byte[MAGIC.length + LAST_BYTES.length];
        System.arraycopy(MAGIC, 0, MAGIC_AND_LAST_BYTES, 0, MAGIC.length);
        LZ4LegacyFrameFormat.MAGIC_AND_LAST_BYTES[LZ4LegacyFrameFormat.MAGIC.length] = 16;
        HEADER_LENGTH = MAGIC.length + 1 + 4 + 4 + 4;
    }
}

