/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.api.attribute;

import io.activej.jmx.api.attribute.JmxReducer;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.jetbrains.annotations.Nullable;

public final class JmxReducers {
    @Nullable
    private static Number reduceNumbers(List<? extends Number> list, Function<DoubleStream, Double> opDouble, Function<LongStream, Long> opLong) {
        if ((list = list.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        Class<?> numberClass = list.get(0).getClass();
        if (JmxReducers.isFloatingPointNumber(numberClass)) {
            return JmxReducers.convert(numberClass, opDouble.apply(list.stream().mapToDouble(Number::doubleValue)));
        }
        if (JmxReducers.isIntegerNumber(numberClass)) {
            return JmxReducers.convert(numberClass, opLong.apply(list.stream().mapToLong(Number::longValue)));
        }
        throw new IllegalArgumentException("Unsupported objects of type: " + numberClass.getName());
    }

    private static boolean isFloatingPointNumber(Class<?> numberClass) {
        return Float.class.isAssignableFrom(numberClass) || Double.class.isAssignableFrom(numberClass);
    }

    private static boolean isIntegerNumber(Class<?> numberClass) {
        return Byte.class.isAssignableFrom(numberClass) || Short.class.isAssignableFrom(numberClass) || Integer.class.isAssignableFrom(numberClass) || Long.class.isAssignableFrom(numberClass);
    }

    private static Number convert(Class<?> targetClass, Number number) {
        if (Byte.class.isAssignableFrom(targetClass)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(targetClass)) {
            return number.shortValue();
        }
        if (Integer.class.isAssignableFrom(targetClass)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(targetClass)) {
            return number.longValue();
        }
        if (Float.class.isAssignableFrom(targetClass)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(targetClass)) {
            return number.doubleValue();
        }
        throw new IllegalArgumentException("target class is not a number class");
    }

    public static final class JmxReducerMax
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> list) {
            return JmxReducers.reduceNumbers(list, s -> s.max().getAsDouble(), s -> s.max().getAsLong());
        }
    }

    public static final class JmxReducerMin
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> list) {
            return JmxReducers.reduceNumbers(list, s -> s.min().getAsDouble(), s -> s.min().getAsLong());
        }
    }

    public static final class JmxReducerSum
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> list) {
            return JmxReducers.reduceNumbers(list, DoubleStream::sum, LongStream::sum);
        }
    }

    public static final class JmxReducerDistinct
    implements JmxReducer<Object> {
        @Override
        public Object reduce(List<?> list) {
            if (list.isEmpty()) {
                return null;
            }
            Object firstValue = list.get(0);
            return list.stream().allMatch(value -> Objects.equals(firstValue, value)) ? firstValue : null;
        }
    }
}

