/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net;

import io.activej.eventloop.Eventloop;
import io.activej.net.AbstractServer;
import io.activej.net.WorkerServer;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PrimaryServer
extends AbstractServer<PrimaryServer> {
    private final WorkerServer[] workerServers;
    private int currentAcceptor = -1;

    private PrimaryServer(Eventloop primaryEventloop, WorkerServer[] workerServers) {
        super(primaryEventloop);
        this.workerServers = workerServers;
        for (WorkerServer workerServer : workerServers) {
            if (!(workerServer instanceof AbstractServer)) continue;
            ((AbstractServer)workerServer).acceptServer = this;
        }
    }

    public static PrimaryServer create(Eventloop primaryEventloop, List<? extends WorkerServer> workerServers) {
        return PrimaryServer.create(primaryEventloop, workerServers.toArray(new WorkerServer[0]));
    }

    public static PrimaryServer create(Eventloop primaryEventloop, Iterable<? extends WorkerServer> workerServers) {
        ArrayList list = new ArrayList();
        workerServers.forEach(list::add);
        return PrimaryServer.create(primaryEventloop, list);
    }

    public static PrimaryServer create(Eventloop primaryEventloop, WorkerServer ... workerServer) {
        return new PrimaryServer(primaryEventloop, workerServer);
    }

    @Override
    protected void serve(AsyncTcpSocket socket, InetAddress remoteAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected WorkerServer getWorkerServer() {
        this.currentAcceptor = (this.currentAcceptor + 1) % this.workerServers.length;
        return this.workerServers[this.currentAcceptor];
    }

    @Override
    public String toString() {
        return "PrimaryServer{numOfWorkerServers=" + this.workerServers.length + (this.listenAddresses.isEmpty() ? "" : ", listenAddresses=" + this.listenAddresses) + (this.sslListenAddresses.isEmpty() ? "" : ", sslListenAddresses=" + this.sslListenAddresses) + (this.acceptOnce ? ", acceptOnce" : "") + ", workerServers=" + Arrays.toString(this.workerServers) + '}';
    }
}

