/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.HexUtils;
import hera.util.Sha256Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base58Utils {
    protected static final Logger logger = LoggerFactory.getLogger(Base58Utils.class);
    protected static final char[] BASE58_CHARS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    protected static final char ENCODED_ZERO = BASE58_CHARS[0];
    protected static final int[] INDEXES = new int[128];
    protected static final int CHECKSUM_LEN = 4;

    public static String encode(byte[] input) {
        int zeros;
        if (null == input || input.length == 0) {
            return "";
        }
        char[] encoded = new char[input.length * 2];
        byte[] copy = Arrays.copyOf(input, input.length);
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        int inputIndex = zeros;
        int outputIndex = encoded.length;
        while (inputIndex < copy.length) {
            encoded[--outputIndex] = BASE58_CHARS[Base58Utils.divmod(copy, inputIndex, 256, 58)];
            if (copy[inputIndex] != 0) continue;
            ++inputIndex;
        }
        while (outputIndex < encoded.length && encoded[outputIndex] == ENCODED_ZERO) {
            ++outputIndex;
        }
        while (--zeros >= 0) {
            encoded[--outputIndex] = ENCODED_ZERO;
        }
        return new String(encoded, outputIndex, encoded.length - outputIndex);
    }

    public static byte[] decode(String input) throws IOException {
        int zeros;
        if (null == input || input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            if (digit < 0) {
                if (logger.isInfoEnabled()) {
                    logger.info("Input:\n{}", (Object)HexUtils.dump(input.getBytes()));
                }
                throw new UnsupportedEncodingException("Base58 decoding failed: " + digit + " at " + i);
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58Utils.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    public static String encodeWithCheck(byte[] rawData) {
        if (null == rawData || rawData.length == 0) {
            return "";
        }
        byte[] checkSum = Base58Utils.calculateCheckSum(rawData);
        byte[] rawTotal = new byte[rawData.length + 4];
        System.arraycopy(rawData, 0, rawTotal, 0, rawData.length);
        System.arraycopy(checkSum, 0, rawTotal, rawTotal.length - 4, 4);
        return Base58Utils.encode(rawTotal);
    }

    public static byte[] decodeWithCheck(String encoded) throws IOException {
        byte[] calculatedCheckSum;
        if (null == encoded || encoded.length() == 0) {
            return new byte[0];
        }
        byte[] rawTotal = Base58Utils.decode(encoded);
        byte[] rawData = Arrays.copyOfRange(rawTotal, 0, rawTotal.length - 4);
        byte[] checkSum = Arrays.copyOfRange(rawTotal, rawTotal.length - 4, rawTotal.length);
        if (!Arrays.equals(checkSum, calculatedCheckSum = Base58Utils.calculateCheckSum(rawData))) {
            logger.info("Checksum is mismatch - Input: {}, Computed: {}", (Object)checkSum, (Object)calculatedCheckSum);
            throw new IllegalArgumentException("Checksum is mismatch");
        }
        return rawData;
    }

    protected static byte[] calculateCheckSum(byte[] rawData) {
        byte[] doubleHashed = Sha256Utils.digest(Sha256Utils.digest(rawData));
        return Arrays.copyOfRange(doubleHashed, 0, 4);
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < BASE58_CHARS.length; ++i) {
            Base58Utils.INDEXES[Base58Utils.BASE58_CHARS[i]] = i;
        }
    }
}

