/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class CryptoUtils {
    public static final String CIPHER_CHARSET = "UTF-8";
    public static final String CIPHER_NAME = "AES/ECB/PKCS5Padding";
    protected static final String DEFAULT_PASSWORD = "tn595hil2n9kolh9";
    protected static SecureRandom random;
    protected static MessageDigest sha;
    protected static MessageDigest md5;
    protected static SecretKeySpec keySpec;

    public static SecretKeySpec createSecret(byte[] password, int length) {
        byte[] fixedLengthPassword = new byte[length];
        Arrays.fill(fixedLengthPassword, (byte)0);
        System.arraycopy(password, 0, fixedLengthPassword, 0, Math.min(fixedLengthPassword.length, password.length));
        return new SecretKeySpec(fixedLengthPassword, "AES");
    }

    public static String encryptToAes128EcbWithBase64(String source) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return CryptoUtils.encryptToAes128EcbWithBase64(source, DEFAULT_PASSWORD);
    }

    public static String encryptToAes128EcbWithBase64(String source, String password) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(password.getBytes(CIPHER_CHARSET), "AES");
            return CryptoUtils.encryptToAes128EcbWithBase64(source.getBytes(CIPHER_CHARSET), secretKeySpec);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encryptToAes128EcbWithBase64(byte[] message, SecretKeySpec secretKeySpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        cipher.init(1, secretKeySpec);
        byte[] aes128ecb = cipher.doFinal(message);
        return BaseEncoding.base64().encode(aes128ecb);
    }

    public static byte[] encryptToAesGcm(byte[] message, byte[] password, byte[] nonce) throws IllegalStateException, InvalidCipherTextException {
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(password), nonce);
        cipher.init(true, (CipherParameters)ivAndKey);
        byte[] outBuf = new byte[cipher.getOutputSize(message.length)];
        int outOff = cipher.processBytes(message, 0, message.length, outBuf, 0);
        cipher.doFinal(outBuf, outOff);
        return outBuf;
    }

    public static byte[] decryptFromAes128EcbWithBase64(String source) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return CryptoUtils.decryptFromAes128EcbWithBase64(source, DEFAULT_PASSWORD);
    }

    public static byte[] decryptFromAes128EcbWithBase64(String source, String password) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(password.getBytes(CIPHER_CHARSET), "AES");
            return CryptoUtils.decryptFromAes128EcbWithBase64(source, secretKeySpec);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] decryptFromAes128EcbWithBase64(String source, SecretKeySpec secretKeySpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] decodedBase64 = BaseEncoding.base64().decode((CharSequence)source);
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        cipher.init(2, secretKeySpec);
        byte[] decoded = cipher.doFinal(decodedBase64);
        return decoded;
    }

    public static byte[] decryptFromAesGcm(byte[] source, byte[] password, byte[] nonce) throws IllegalStateException, InvalidCipherTextException {
        GCMBlockCipher cppher = new GCMBlockCipher((BlockCipher)new AESEngine());
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(password), nonce);
        cppher.init(false, (CipherParameters)ivAndKey);
        byte[] outBuf = new byte[cppher.getOutputSize(source.length)];
        int outOff = cppher.processBytes(source, 0, source.length, outBuf, 0);
        cppher.doFinal(outBuf, outOff);
        return outBuf;
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            sha = MessageDigest.getInstance("SHA-1");
            md5 = MessageDigest.getInstance("MD5");
            keySpec = new SecretKeySpec(DEFAULT_PASSWORD.getBytes(CIPHER_CHARSET), "AES");
        }
        catch (Throwable th) {
            throw new IllegalStateException(th);
        }
    }
}

