/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.StringUtils;

public class FilenameUtils {
    private static final char EXTENSION_SEPARATOR = '.';

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension(filename, false);
    }

    public static String getExtension(String filename, boolean isGreedy) {
        if (null == filename) {
            return null;
        }
        int dotIndex = isGreedy ? filename.indexOf(46) : filename.lastIndexOf(46);
        return dotIndex < 0 ? "" : filename.substring(dotIndex + 1);
    }

    public static String stripExtension(String filename) {
        if (null == filename) {
            return null;
        }
        int index = filename.lastIndexOf(46);
        return index < 0 ? filename : filename.substring(0, index);
    }

    public static String makeFilename(String name, String ext) {
        if (null == name || null == ext) {
            return null;
        }
        if (StringUtils.isEmpty(ext)) {
            return name;
        }
        StringBuilder buffer = new StringBuilder();
        if (!StringUtils.isEmpty(name)) {
            buffer.append(StringUtils.nvl(name));
        }
        buffer.append('.');
        buffer.append(ext);
        return buffer.toString();
    }
}

