/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.NumberUtils;
import hera.util.StringUtils;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ParsingUtils {
    protected static final Collection<String> TRUES = new HashSet<String>(Arrays.asList("yes", "y", "true", "1"));
    protected static final Collection<String> FALSES = new HashSet<String>(Arrays.asList("no", "n", "false", "0"));
    public static final List<ScaleUnit> INTERVALS = Collections.unmodifiableList(Arrays.asList(new ScaleUnit("microseconds", 1L), new ScaleUnit("\u00b5s", 1L), new ScaleUnit("milliseconds", 1000L), new ScaleUnit("ms", 1000L), new ScaleUnit("seconds", 1000000L), new ScaleUnit("sec", 1000000L), new ScaleUnit("minutes", 60000000L), new ScaleUnit("min", 60000000L), new ScaleUnit("m", 60000000L), new ScaleUnit("hours", 3600000000L), new ScaleUnit("hr", 3600000000L), new ScaleUnit("h", 3600000000L), new ScaleUnit("s", 1000000L)));

    public static boolean convertToBoolean(String str, boolean defaultValueIsTrue) {
        if (null == str) {
            return defaultValueIsTrue;
        }
        String safeStr = StringUtils.trim(str).toLowerCase();
        if (defaultValueIsTrue) {
            return !FALSES.contains(safeStr);
        }
        return TRUES.contains(safeStr);
    }

    public static boolean convertToBoolean(String val) {
        return ParsingUtils.convertToBoolean(val, false);
    }

    public static int convertToInt(String val) {
        return ParsingUtils.convertToInt(val, 0);
    }

    public static int convertToInt(String val, int defaultValue) {
        try {
            return (Integer)NumberUtils.parse(val, Integer.TYPE);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static long convertToLong(String val) {
        return ParsingUtils.convertToLong(val, 0);
    }

    public static long convertToLong(String val, int defaultValue) {
        try {
            return (Long)NumberUtils.parse(val, Long.TYPE);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static long convertToLong(String val, long defaultValue) {
        if (null == val) {
            return defaultValue;
        }
        try {
            return (Long)NumberUtils.parse(val, Long.TYPE);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static double convertToDouble(String val) {
        return ParsingUtils.convertToDouble(val, 0.0);
    }

    public static double convertToDouble(String val, double defaultValue) {
        if (null == val) {
            return defaultValue;
        }
        try {
            return (Double)NumberUtils.parse(val, Double.TYPE);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static long convertToCapacity(String str, long defaultValue) {
        if (null == str) {
            return defaultValue;
        }
        String safe = str.trim();
        char unit = safe.charAt(safe.length() - 1);
        String valuePart = safe.substring(0, safe.length() - 1);
        long value = Long.parseLong(valuePart);
        if ('k' == Character.toLowerCase(unit)) {
            return 1000L * value;
        }
        if ('m' == Character.toLowerCase(unit)) {
            return 1000000L * value;
        }
        if ('g' == Character.toLowerCase(unit)) {
            return 1000000000L * value;
        }
        return value;
    }

    public static long convertToTime(String val) throws ParseException {
        if (null == val) {
            return 0L;
        }
        String lowerVal = val.toLowerCase();
        for (ScaleUnit unit : INTERVALS) {
            String units = unit.units;
            if (!lowerVal.endsWith(units)) continue;
            String digits = lowerVal.substring(0, lowerVal.length() - units.length()).trim();
            Double microSeconds = Double.parseDouble(digits) * (double)unit.scale;
            return microSeconds.longValue();
        }
        throw new ParseException(val, 0);
    }

    public static long parse(String val, TimeUnit unit) throws ParseException {
        long time = ParsingUtils.convertToTime(val);
        return unit.convert(time, TimeUnit.MICROSECONDS);
    }

    public static class ScaleUnit {
        public final String units;
        public final long scale;

        public ScaleUnit(String units, long scale) {
            this.units = units;
            this.scale = scale;
        }
    }
}

