/*
 * Decompiled with CFR 0.152.
 */
package hera.util.conf;

import hera.util.Configuration;
import hera.util.ValidationUtils;
import hera.util.conf.AbstractConfiguration;
import hera.util.conf.InMemoryConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemPropertiesConfiguration
extends AbstractConfiguration
implements Configuration {
    @Override
    public Map<String, Object> asMap() {
        Properties map = System.getProperties();
        return Collections.unmodifiableMap(new HashMap<Object, Object>(map));
    }

    @Override
    public void define(String key, Object value) {
        throw new UnsupportedOperationException("JVM Properties could NOT be changed");
    }

    @Override
    public Configuration getSubconfiguration(String key) {
        String prefix = key + ".";
        InMemoryConfiguration subconfiguration = new InMemoryConfiguration();
        Set<String> stringProperties = System.getProperties().stringPropertyNames();
        for (String name : stringProperties) {
            if (!name.startsWith(prefix)) continue;
            String subname = name.substring(prefix.length());
            subconfiguration.define(subname, System.getProperty(name));
        }
        return subconfiguration;
    }

    @Override
    public Object getValue(String key) {
        ValidationUtils.assertFalse(key.contains("."));
        return System.getProperty(key);
    }

    @Override
    public void remove(String key) {
        throw new UnsupportedOperationException("JVM Properties could NOT be changed");
    }
}

