/*
 * Decompiled with CFR 0.152.
 */
package hera.util.pki;

import hera.util.HexUtils;
import hera.util.ValidationUtils;
import hera.util.pki.ECDSASignature;
import hera.util.pki.ECDSAVerifier;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSAKey {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PrivateKey privateKey;
    protected final PublicKey publicKey;
    protected final ECDomainParameters params;
    protected final ECDSAVerifier verifier;

    public static ECDSAKey of(PrivateKey privateKey, PublicKey publicKey, ECDomainParameters ecParams) {
        return new ECDSAKey(privateKey, publicKey, ecParams);
    }

    protected ECDSAKey(PrivateKey privateKey, PublicKey publicKey, ECDomainParameters ecParams) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.params = ecParams;
        this.verifier = new ECDSAVerifier(this.params);
    }

    public ECDSASignature sign(byte[] hashedMessage) {
        try {
            ValidationUtils.assertEquals((Object)hashedMessage.length, (Object)32, "Sha-256 hashed message should have 32 bytes length");
            ECDSASignature signature = this.sign(this.privateKey, hashedMessage);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Message in hexa: {}", (Object)HexUtils.encode(hashedMessage));
                this.logger.trace("ECDSASignature signature: {}", (Object)signature);
            }
            return signature;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    protected ECDSASignature sign(PrivateKey privateKey, byte[] message) throws Exception {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        BigInteger d = ((ECPrivateKey)privateKey).getD();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(d, this.params);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(message);
        BigInteger r = components[0];
        BigInteger s = this.params.getN().subtract(components[1]);
        return new ECDSASignature(r, s);
    }

    public boolean verify(byte[] hashedMessage, ECDSASignature signature) {
        try {
            return this.verifier.verify(this.getPublicKey(), hashedMessage, signature);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)this.privateKey;
        ECPublicKey ecPublicKey = (ECPublicKey)this.publicKey;
        return String.format("%s\n%s", ecPrivateKey.toString(), ecPublicKey.toString());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ECDSAKey)) {
            return false;
        }
        ECDSAKey other = (ECDSAKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        ECDomainParameters this$params = this.getParams();
        ECDomainParameters other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        ECDSAVerifier this$verifier = this.getVerifier();
        ECDSAVerifier other$verifier = other.getVerifier();
        return !(this$verifier == null ? other$verifier != null : !((Object)this$verifier).equals(other$verifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ECDSAKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        ECDomainParameters $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        ECDSAVerifier $verifier = this.getVerifier();
        result = result * 59 + ($verifier == null ? 43 : ((Object)$verifier).hashCode());
        return result;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public ECDomainParameters getParams() {
        return this.params;
    }

    public ECDSAVerifier getVerifier() {
        return this.verifier;
    }
}

