/*
 * Decompiled with CFR 0.152.
 */
package hera.util.pki;

import hera.util.Sha256Utils;
import hera.util.pki.ECDSAKey;
import hera.util.pki.KeyGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSAKeyGenerator
implements KeyGenerator<ECDSAKey> {
    protected static final String KEY_ALGORITHM = "ECDSA";
    protected static final String CURVE_NAME = "secp256k1";
    protected static final ECNamedCurveParameterSpec ecSpec;
    public static final ECDomainParameters ecParams;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ECDSAKey generateKey(SecureRandom secureRandom) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator generator = this.getKeyPairGenerator(secureRandom);
        KeyPair pair = generator.generateKeyPair();
        PrivateKey privateKey = pair.getPrivate();
        PublicKey publicKey = pair.getPublic();
        this.logger.trace("Public key: {}", (Object)publicKey);
        return new ECDSAKey(privateKey, publicKey, ecParams);
    }

    protected KeyPairGenerator getKeyPairGenerator(SecureRandom secureRandom) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)ecSpec, secureRandom);
        this.logger.debug("Generator: {}", (Object)keyPairGenerator);
        return keyPairGenerator;
    }

    @Override
    public ECDSAKey create() throws Exception {
        return this.generateKey(new SecureRandom());
    }

    public ECDSAKey create(String seed) throws Exception {
        byte[] digested = Sha256Utils.digest(seed.getBytes());
        FixedSecureRandom secureRandom = new FixedSecureRandom(digested);
        return this.generateKey((SecureRandom)secureRandom);
    }

    public ECDSAKey create(byte[] encodedPrivateKey) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        return this.create(factory.generatePrivate(spec));
    }

    public ECDSAKey create(BigInteger d) throws Exception {
        return this.create(this.createPrivateKey(d));
    }

    public ECDSAKey create(PrivateKey privateKey) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        ECPoint Q = ecSpec.getG().multiply(((ECPrivateKey)privateKey).getD());
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(Q, (ECParameterSpec)ecSpec);
        PublicKey publicKey = factory.generatePublic((KeySpec)ecPublicKeySpec);
        return new ECDSAKey(privateKey, publicKey, ecParams);
    }

    public PrivateKey createPrivateKey(BigInteger d) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        ECPrivateKeySpec spec = new ECPrivateKeySpec(d, (ECParameterSpec)ecSpec);
        return factory.generatePrivate((KeySpec)spec);
    }

    public PublicKey createPublicKey(byte[] compressed) throws Exception {
        return this.createPublicKey(ecParams.getCurve().decodePoint(compressed));
    }

    public PublicKey createPublicKey(BigInteger x, BigInteger y) throws Exception {
        return this.createPublicKey(ecParams.getCurve().createPoint(x, y));
    }

    protected PublicKey createPublicKey(ECPoint ecPoint) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecSpec);
        return factory.generatePublic((KeySpec)spec);
    }

    static {
        Provider provider = Security.getProvider("BC");
        if (provider != null) {
            Security.removeProvider("BC");
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        ecParams = new ECDomainParameters(ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN(), ecSpec.getH(), ecSpec.getSeed());
    }
}

