/*
 * Decompiled with CFR 0.152.
 */
package hera.util.pki;

import hera.util.HexUtils;
import hera.util.ValidationUtils;
import hera.util.pki.ECDSASignature;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSAVerifier {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ECDomainParameters params;

    public boolean verify(PublicKey publicKey, byte[] hashedMessage, ECDSASignature signature) {
        try {
            ValidationUtils.assertEquals((Object)hashedMessage.length, (Object)32, "Sha-256 hashed message should have 32 byte length");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Message in hexa: {}", (Object)HexUtils.encode(hashedMessage));
                this.logger.trace("ECDSASignature signature: {}", (Object)signature);
            }
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
            ECPublicKeyParameters privKey = new ECPublicKeyParameters(ecPublicKey.getQ(), this.params);
            signer.init(false, (CipherParameters)privKey);
            return signer.verifySignature(hashedMessage, signature.getR(), signature.getS());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return "ECDSAVerifier(logger=" + this.logger + ", params=" + this.getParams() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ECDSAVerifier)) {
            return false;
        }
        ECDSAVerifier other = (ECDSAVerifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ECDomainParameters this$params = this.getParams();
        ECDomainParameters other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ECDSAVerifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ECDomainParameters $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public ECDSAVerifier(ECDomainParameters params) {
        this.params = params;
    }

    public ECDomainParameters getParams() {
        return this.params;
    }
}

