/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.net.InetSocketAddress;

public class UnicastFlowControl
implements FlowControl {
    private long positionLimit = 0L;
    private int positionBitsToShift;
    private int initialTermId;

    @Override
    public long onStatusMessage(int termId, int termOffset, int receiverWindowLength, InetSocketAddress address) {
        long position = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
        long newPositionLimit = position + (long)receiverWindowLength;
        this.positionLimit = Math.max(this.positionLimit, newPositionLimit);
        return this.positionLimit;
    }

    @Override
    public void initialize(int initialTermId, int termBufferCapacity) {
        this.initialTermId = initialTermId;
        this.positionBitsToShift = Long.numberOfTrailingZeros(termBufferCapacity);
        this.positionLimit = 0L;
    }

    @Override
    public long onIdle(long now) {
        return this.positionLimit;
    }
}

