/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkInterfaceShim;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.agrona.BufferUtil;

public class NetworkUtil {
    public static Collection<NetworkInterface> filterBySubnet(InetAddress address, int subnetPrefix) throws SocketException {
        return NetworkUtil.filterBySubnet(NetworkInterfaceShim.DEFAULT, address, subnetPrefix);
    }

    static Collection<NetworkInterface> filterBySubnet(NetworkInterfaceShim shim, InetAddress address, int subnetPrefix) throws SocketException {
        ArrayList<FilterResult> filterResults = new ArrayList<FilterResult>();
        byte[] queryAddress = address.getAddress();
        Enumeration<NetworkInterface> ifcs = shim.getNetworkInterfaces();
        while (ifcs.hasMoreElements()) {
            NetworkInterface ifc = ifcs.nextElement();
            InterfaceAddress interfaceAddress = NetworkUtil.findAddressOnInterface(shim, ifc, queryAddress, subnetPrefix);
            if (null == interfaceAddress) continue;
            filterResults.add(new FilterResult(interfaceAddress, ifc, shim.isLoopback(ifc)));
        }
        Collections.sort(filterResults);
        ArrayList<NetworkInterface> results = new ArrayList<NetworkInterface>();
        filterResults.forEach(filterResult -> results.add(((FilterResult)filterResult).ifc));
        return results;
    }

    public static InetAddress findAddressOnInterface(NetworkInterface ifc, InetAddress address, int subnetPrefix) {
        InterfaceAddress interfaceAddress = NetworkUtil.findAddressOnInterface(NetworkInterfaceShim.DEFAULT, ifc, address.getAddress(), subnetPrefix);
        if (null == interfaceAddress) {
            return null;
        }
        return interfaceAddress.getAddress();
    }

    static InterfaceAddress findAddressOnInterface(NetworkInterfaceShim shim, NetworkInterface ifc, byte[] queryAddress, int prefixLength) {
        InterfaceAddress foundInterfaceAddress = null;
        for (InterfaceAddress interfaceAddress : shim.getInterfaceAddresses(ifc)) {
            byte[] candidateAddress = interfaceAddress.getAddress().getAddress();
            if (!NetworkUtil.isMatchWithPrefix(candidateAddress, queryAddress, prefixLength)) continue;
            foundInterfaceAddress = interfaceAddress;
            break;
        }
        return foundInterfaceAddress;
    }

    static boolean isMatchWithPrefix(byte[] candidate, byte[] expected, int prefixLength) {
        if (candidate.length != expected.length) {
            return false;
        }
        if (candidate.length == 4) {
            int mask = NetworkUtil.prefixLengthToIpV4Mask(prefixLength);
            return (NetworkUtil.toInt(candidate) & mask) == (NetworkUtil.toInt(expected) & mask);
        }
        if (candidate.length == 16) {
            long upperMask = NetworkUtil.prefixLengthToIpV6Mask(Math.min(prefixLength, 64));
            long lowerMask = NetworkUtil.prefixLengthToIpV6Mask(Math.max(prefixLength - 64, 0));
            return (upperMask & NetworkUtil.toLong(candidate, 0)) == (upperMask & NetworkUtil.toLong(expected, 0)) && (lowerMask & NetworkUtil.toLong(candidate, 8)) == (lowerMask & NetworkUtil.toLong(expected, 8));
        }
        throw new IllegalArgumentException("How many bytes does an IP address have again?");
    }

    private static int prefixLengthToIpV4Mask(int subnetPrefix) {
        return 0 == subnetPrefix ? 0 : ~((1 << 32 - subnetPrefix) - 1);
    }

    private static long prefixLengthToIpV6Mask(int subnetPrefix) {
        return 0 == subnetPrefix ? 0L : (1L << 64 - subnetPrefix) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static int toInt(byte[] b) {
        return (b[3] & 0xFF) + ((b[2] & 0xFF) << 8) + ((b[1] & 0xFF) << 16) + (b[0] << 24);
    }

    static long toLong(byte[] b, int offset) {
        return ((long)b[offset + 7] & 0xFFL) + (((long)b[offset + 6] & 0xFFL) << 8) + (((long)b[offset + 5] & 0xFFL) << 16) + (((long)b[offset + 4] & 0xFFL) << 24) + (((long)b[offset + 3] & 0xFFL) << 32) + (((long)b[offset + 2] & 0xFFL) << 40) + (((long)b[offset + 1] & 0xFFL) << 48) + ((long)b[offset] << 56);
    }

    public static ProtocolFamily getProtocolFamily(InetAddress address) {
        if (address instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (address instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalStateException("Unknown ProtocolFamily");
    }

    public static ByteBuffer allocateDirectAlignedAndPadded(int capacity, int alignment) {
        ByteBuffer buffer = BufferUtil.allocateDirectAligned((int)(capacity + alignment), (int)alignment);
        buffer.limit(buffer.limit() - alignment);
        return buffer.slice();
    }

    static class FilterResult
    implements Comparable<FilterResult> {
        private final InterfaceAddress interfaceAddress;
        private final NetworkInterface ifc;
        private final boolean isLoopback;

        FilterResult(InterfaceAddress interfaceAddress, NetworkInterface ifc, boolean isLoopback) throws SocketException {
            this.interfaceAddress = interfaceAddress;
            this.ifc = ifc;
            this.isLoopback = isLoopback;
        }

        @Override
        public int compareTo(FilterResult other) {
            if (this.isLoopback == other.isLoopback) {
                return -Integer.compare(this.interfaceAddress.getNetworkPrefixLength(), other.interfaceAddress.getNetworkPrefixLength());
            }
            return Boolean.compare(this.isLoopback, other.isLoopback);
        }
    }
}

