/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.exceptions.ControlProtocolException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class ClientCommandAdapter
implements MessageHandler {
    private final PublicationMessageFlyweight publicationMsgFlyweight = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMsgFlyweight = new SubscriptionMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMsgFlyweight = new CorrelatedMessageFlyweight();
    private final RemoveMessageFlyweight removeMsgFlyweight = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMsgFlyweight = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMsgFlyweight = new CounterMessageFlyweight();
    private final DriverConductor conductor;
    private final RingBuffer toDriverCommands;
    private final ClientProxy clientProxy;
    private final AtomicCounter errors;
    private final ErrorHandler errorHandler;

    ClientCommandAdapter(AtomicCounter errors, ErrorHandler errorHandler, RingBuffer toDriverCommands, ClientProxy clientProxy, DriverConductor driverConductor) {
        this.errors = errors;
        this.errorHandler = errorHandler;
        this.toDriverCommands = toDriverCommands;
        this.clientProxy = clientProxy;
        this.conductor = driverConductor;
    }

    public int receive() {
        return this.toDriverCommands.read((MessageHandler)this, 10);
    }

    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        long correlationId = 0L;
        try {
            switch (msgTypeId) {
                case 1: {
                    this.publicationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(correlationId, false);
                    break;
                }
                case 2: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemovePublication(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 3: {
                    this.publicationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(correlationId, true);
                    break;
                }
                case 4: {
                    this.subscriptionMsgFlyweight.wrap(buffer, index);
                    correlationId = this.subscriptionMsgFlyweight.correlationId();
                    int streamId = this.subscriptionMsgFlyweight.streamId();
                    long clientId = this.subscriptionMsgFlyweight.clientId();
                    String channel = this.subscriptionMsgFlyweight.channel();
                    if (channel.startsWith("aeron:ipc")) {
                        this.conductor.onAddIpcSubscription(channel, streamId, correlationId, clientId);
                        break;
                    }
                    if (channel.startsWith("aeron-spy:")) {
                        this.conductor.onAddSpySubscription(channel, streamId, correlationId, clientId);
                        break;
                    }
                    this.conductor.onAddNetworkSubscription(channel, streamId, correlationId, clientId);
                    break;
                }
                case 5: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveSubscription(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 7: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 8: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 6: {
                    this.correlatedMsgFlyweight.wrap(buffer, index);
                    this.conductor.onClientKeepalive(this.correlatedMsgFlyweight.clientId());
                    break;
                }
                case 9: {
                    this.counterMsgFlyweight.wrap(buffer, index);
                    correlationId = this.counterMsgFlyweight.correlationId();
                    this.conductor.onAddCounter(this.counterMsgFlyweight.typeId(), (DirectBuffer)buffer, index + this.counterMsgFlyweight.keyBufferOffset(), this.counterMsgFlyweight.keyBufferLength(), (DirectBuffer)buffer, index + this.counterMsgFlyweight.labelBufferOffset(), this.counterMsgFlyweight.labelBufferLength(), correlationId, this.counterMsgFlyweight.clientId());
                    break;
                }
                case 10: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveCounter(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 11: {
                    this.correlatedMsgFlyweight.wrap(buffer, index);
                    correlationId = this.correlatedMsgFlyweight.correlationId();
                    this.conductor.onClientClose(this.correlatedMsgFlyweight.clientId(), correlationId);
                    break;
                }
                case 12: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddRcvDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 13: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveRcvDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
            }
        }
        catch (ControlProtocolException ex) {
            this.clientProxy.onError(correlationId, ex.errorCode(), ex.getMessage());
            this.recordError((Exception)((Object)ex));
        }
        catch (Exception ex) {
            String errorMessage = ex.getClass().getSimpleName() + " : " + ex.getMessage();
            this.clientProxy.onError(correlationId, ErrorCode.GENERIC_ERROR, errorMessage);
            this.recordError(ex);
        }
    }

    public void addPublication(long correlationId, boolean isExclusive) {
        int streamId = this.publicationMsgFlyweight.streamId();
        long clientId = this.publicationMsgFlyweight.clientId();
        String channel = this.publicationMsgFlyweight.channel();
        if (channel.startsWith("aeron:ipc")) {
            this.conductor.onAddIpcPublication(channel, streamId, correlationId, clientId, isExclusive);
        } else {
            this.conductor.onAddNetworkPublication(channel, streamId, correlationId, clientId, isExclusive);
        }
    }

    private void recordError(Exception ex) {
        this.errors.increment();
        this.errorHandler.onError((Throwable)ex);
    }
}

