/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.exceptions.UnknownSubscriptionException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.net.InetSocketAddress;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public class DataPacketDispatcher {
    private final Int2ObjectHashMap<StreamInterest> streamInterestByIdMap = new Int2ObjectHashMap();
    private final DriverConductorProxy conductorProxy;
    private final Receiver receiver;

    public DataPacketDispatcher(DriverConductorProxy conductorProxy, Receiver receiver) {
        this.conductorProxy = conductorProxy;
        this.receiver = receiver;
    }

    public void addSubscription(int streamId) {
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null == streamInterest) {
            this.streamInterestByIdMap.put(streamId, (Object)new StreamInterest(true));
        } else if (!streamInterest.isForAllSessions) {
            streamInterest.isForAllSessions = true;
            Int2ObjectHashMap.KeyIterator keyIterator = streamInterest.sessionInterestByIdMap.keySet().iterator();
            while (keyIterator.hasNext()) {
                int sessionId = (Integer)keyIterator.next();
                SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
                if (SessionState.NO_INTEREST != sessionInterest.state) continue;
                streamInterest.sessionInterestByIdMap.remove(sessionId);
            }
        }
    }

    public void addSubscription(int streamId, int sessionId) {
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null == streamInterest) {
            streamInterest = new StreamInterest(false);
            this.streamInterestByIdMap.put(streamId, (Object)streamInterest);
        }
        streamInterest.subscribedSessionIds.add(sessionId);
        SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
        if (null != sessionInterest && SessionState.NO_INTEREST == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(sessionId);
        }
    }

    public void removeSubscription(int streamId) {
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null == streamInterest) {
            throw new UnknownSubscriptionException("No subscription registered on stream " + streamId);
        }
        Int2ObjectHashMap.KeyIterator keyIterator = streamInterest.sessionInterestByIdMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            int sessionId = (Integer)keyIterator.next();
            SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
            if (streamInterest.subscribedSessionIds.contains(sessionId)) continue;
            if (null != sessionInterest.image) {
                sessionInterest.image.ifActiveGoInactive();
            }
            streamInterest.sessionInterestByIdMap.remove(sessionId);
        }
        streamInterest.isForAllSessions = false;
        if (streamInterest.subscribedSessionIds.isEmpty()) {
            this.streamInterestByIdMap.remove(streamId);
        }
    }

    public void removeSubscription(int streamId, int sessionId) {
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null == streamInterest) {
            throw new UnknownSubscriptionException("No subscription registered on stream " + streamId);
        }
        SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.remove(sessionId);
        if (null != sessionInterest && null != sessionInterest.image) {
            sessionInterest.image.ifActiveGoInactive();
        }
        streamInterest.subscribedSessionIds.remove(sessionId);
        if (!streamInterest.isForAllSessions && streamInterest.subscribedSessionIds.isEmpty()) {
            this.streamInterestByIdMap.remove(streamId);
        }
    }

    public void addPublicationImage(PublicationImage image) {
        int sessionId = image.sessionId();
        int streamId = image.streamId();
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
        if (null == sessionInterest) {
            sessionInterest = new SessionInterest(SessionState.ACTIVE);
            streamInterest.sessionInterestByIdMap.put(sessionId, (Object)sessionInterest);
        } else {
            sessionInterest.state = SessionState.ACTIVE;
        }
        sessionInterest.image = image;
        image.activate();
    }

    public void removePublicationImage(PublicationImage image) {
        SessionInterest sessionInterest;
        int sessionId = image.sessionId();
        int streamId = image.streamId();
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest && null != (sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId)) && null != sessionInterest.image && sessionInterest.image.correlationId() == image.correlationId()) {
            sessionInterest.state = SessionState.ON_COOL_DOWN;
            sessionInterest.image = null;
        }
        image.ifActiveGoInactive();
    }

    public void removePendingSetup(int sessionId, int streamId) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest && null != (sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId)) && SessionState.PENDING_SETUP_FRAME == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(sessionId);
        }
    }

    public void removeCoolDown(int sessionId, int streamId) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest && null != (sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId)) && SessionState.ON_COOL_DOWN == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(sessionId);
        }
    }

    public int onDataPacket(ReceiveChannelEndpoint channelEndpoint, DataHeaderFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress, int transportIndex) {
        int streamId = header.streamId();
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest) {
            int sessionId = header.sessionId();
            int termId = header.termId();
            SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
            if (null != sessionInterest) {
                if (null != sessionInterest.image) {
                    return sessionInterest.image.insertPacket(termId, header.termOffset(), buffer, length, transportIndex, srcAddress);
                }
            } else if (!DataHeaderFlyweight.isEndOfStream((UnsafeBuffer)buffer)) {
                if (streamInterest.isForAllSessions || streamInterest.subscribedSessionIds.contains(sessionId)) {
                    streamInterest.sessionInterestByIdMap.put(sessionId, (Object)new SessionInterest(SessionState.PENDING_SETUP_FRAME));
                    this.elicitSetupMessageFromSource(channelEndpoint, transportIndex, srcAddress, streamId, sessionId);
                } else {
                    streamInterest.sessionInterestByIdMap.put(sessionId, (Object)new SessionInterest(SessionState.NO_INTEREST));
                }
            }
        }
        return 0;
    }

    public void onSetupMessage(ReceiveChannelEndpoint channelEndpoint, SetupFlyweight header, InetSocketAddress srcAddress, int transportIndex) {
        int streamId = header.streamId();
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest) {
            int sessionId = header.sessionId();
            int initialTermId = header.initialTermId();
            int activeTermId = header.activeTermId();
            SessionInterest sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId);
            if (null != sessionInterest) {
                if (null == sessionInterest.image && SessionState.PENDING_SETUP_FRAME == sessionInterest.state) {
                    sessionInterest.state = SessionState.INIT_IN_PROGRESS;
                    this.createPublicationImage(channelEndpoint, transportIndex, srcAddress, streamId, sessionId, initialTermId, activeTermId, header.termOffset(), header.termLength(), header.mtuLength(), header.ttl());
                } else if (null != sessionInterest.image) {
                    sessionInterest.image.addControlAddressIfUnknown(transportIndex, srcAddress);
                }
            } else if (streamInterest.isForAllSessions || streamInterest.subscribedSessionIds.contains(sessionId)) {
                streamInterest.sessionInterestByIdMap.put(sessionId, (Object)new SessionInterest(SessionState.INIT_IN_PROGRESS));
                this.createPublicationImage(channelEndpoint, transportIndex, srcAddress, streamId, sessionId, initialTermId, activeTermId, header.termOffset(), header.termLength(), header.mtuLength(), header.ttl());
            } else {
                streamInterest.sessionInterestByIdMap.put(sessionId, (Object)new SessionInterest(SessionState.NO_INTEREST));
            }
        }
    }

    public void onRttMeasurement(ReceiveChannelEndpoint channelEndpoint, RttMeasurementFlyweight header, InetSocketAddress srcAddress, int transportIndex) {
        int sessionId;
        SessionInterest sessionInterest;
        int streamId = header.streamId();
        StreamInterest streamInterest = (StreamInterest)this.streamInterestByIdMap.get(streamId);
        if (null != streamInterest && null != (sessionInterest = (SessionInterest)streamInterest.sessionInterestByIdMap.get(sessionId = header.sessionId())) && null != sessionInterest.image) {
            if (128 == (header.flags() & 0x80)) {
                InetSocketAddress controlAddress = channelEndpoint.isMulticast(transportIndex) ? channelEndpoint.udpChannel(transportIndex).remoteControl() : srcAddress;
                channelEndpoint.sendRttMeasurement(transportIndex, controlAddress, sessionId, streamId, header.echoTimestampNs(), 0L, false);
            } else {
                sessionInterest.image.onRttMeasurement(header, transportIndex, srcAddress);
            }
        }
    }

    public boolean shouldElicitSetupMessage() {
        return !this.streamInterestByIdMap.isEmpty();
    }

    private void elicitSetupMessageFromSource(ReceiveChannelEndpoint channelEndpoint, int transportIndex, InetSocketAddress srcAddress, int streamId, int sessionId) {
        InetSocketAddress controlAddress = channelEndpoint.isMulticast(transportIndex) ? channelEndpoint.udpChannel(transportIndex).remoteControl() : srcAddress;
        channelEndpoint.sendSetupElicitingStatusMessage(transportIndex, controlAddress, sessionId, streamId);
        this.receiver.addPendingSetupMessage(sessionId, streamId, transportIndex, channelEndpoint, false, controlAddress);
    }

    private void createPublicationImage(ReceiveChannelEndpoint channelEndpoint, int transportIndex, InetSocketAddress srcAddress, int streamId, int sessionId, int initialTermId, int activeTermId, int termOffset, int termLength, int mtuLength, int setupTtl) {
        InetSocketAddress controlAddress;
        InetSocketAddress inetSocketAddress = controlAddress = channelEndpoint.isMulticast(transportIndex) ? channelEndpoint.udpChannel(transportIndex).remoteControl() : srcAddress;
        if (channelEndpoint.isMulticast(transportIndex) && channelEndpoint.multicastTtl(transportIndex) < setupTtl) {
            channelEndpoint.possibleTtlAsymmetryEncountered();
        }
        this.conductorProxy.createPublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, transportIndex, controlAddress, srcAddress, channelEndpoint);
    }

    static class StreamInterest {
        boolean isForAllSessions;
        Int2ObjectHashMap<SessionInterest> sessionInterestByIdMap;
        IntHashSet subscribedSessionIds;

        StreamInterest(boolean isForAllSessions) {
            this.isForAllSessions = isForAllSessions;
            this.sessionInterestByIdMap = new Int2ObjectHashMap();
            this.subscribedSessionIds = new IntHashSet();
        }
    }

    static class SessionInterest {
        SessionState state;
        PublicationImage image;

        SessionInterest(SessionState state) {
            this.state = state;
        }
    }

    static enum SessionState {
        ACTIVE,
        PENDING_SETUP_FRAME,
        INIT_IN_PROGRESS,
        ON_COOL_DOWN,
        NO_INTEREST;

    }
}

