/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.Receiver;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.Sender;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.buffer.RawLogFactory;
import io.aeron.driver.exceptions.ActiveDriverException;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.reports.LossReport;
import io.aeron.driver.reports.LossReportUtil;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.errors.LoggingErrorHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.ConcurrentCountersManager;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public final class MediaDriver
implements AutoCloseable {
    private boolean wasHighResTimerEnabled;
    private final AgentRunner sharedRunner;
    private final AgentRunner sharedNetworkRunner;
    private final AgentRunner conductorRunner;
    private final AgentRunner receiverRunner;
    private final AgentRunner senderRunner;
    private final AgentInvoker sharedInvoker;
    private final Context ctx;

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (MediaDriver ignore = MediaDriver.launch();){
            new ShutdownSignalBarrier().await();
            System.out.println("Shutdown Driver...");
        }
    }

    private MediaDriver(Context ctx) {
        this.ctx = ctx;
        ctx.concludeAeronDirectory();
        MediaDriver.ensureDirectoryIsRecreated(ctx);
        Configuration.validateSocketBufferLengths(ctx);
        ctx.conclude();
        DriverConductor conductor = new DriverConductor(ctx);
        Receiver receiver = new Receiver(ctx);
        Sender sender = new Sender(ctx);
        ctx.receiverProxy().receiver(receiver);
        ctx.senderProxy().sender(sender);
        ctx.driverConductorProxy().driverConductor(conductor);
        AtomicCounter errorCounter = ctx.systemCounters().get(SystemCounterDescriptor.ERRORS);
        ErrorHandler errorHandler = ctx.errorHandler();
        switch (ctx.threadingMode()) {
            case INVOKER: {
                this.sharedInvoker = new AgentInvoker(errorHandler, errorCounter, (Agent)new CompositeAgent(new Agent[]{sender, receiver, conductor}));
                this.sharedRunner = null;
                this.sharedNetworkRunner = null;
                this.conductorRunner = null;
                this.receiverRunner = null;
                this.senderRunner = null;
                break;
            }
            case SHARED: {
                this.sharedRunner = new AgentRunner(ctx.sharedIdleStrategy(), errorHandler, errorCounter, (Agent)new CompositeAgent(new Agent[]{sender, receiver, conductor}));
                this.sharedNetworkRunner = null;
                this.conductorRunner = null;
                this.receiverRunner = null;
                this.senderRunner = null;
                this.sharedInvoker = null;
                break;
            }
            case SHARED_NETWORK: {
                this.sharedNetworkRunner = new AgentRunner(ctx.sharedNetworkIdleStrategy(), errorHandler, errorCounter, (Agent)new CompositeAgent(new Agent[]{sender, receiver}));
                this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy(), errorHandler, errorCounter, (Agent)conductor);
                this.sharedRunner = null;
                this.receiverRunner = null;
                this.senderRunner = null;
                this.sharedInvoker = null;
                break;
            }
            default: {
                this.senderRunner = new AgentRunner(ctx.senderIdleStrategy(), errorHandler, errorCounter, (Agent)sender);
                this.receiverRunner = new AgentRunner(ctx.receiverIdleStrategy(), errorHandler, errorCounter, (Agent)receiver);
                this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy(), errorHandler, errorCounter, (Agent)conductor);
                this.sharedNetworkRunner = null;
                this.sharedRunner = null;
                this.sharedInvoker = null;
            }
        }
    }

    public static MediaDriver launchEmbedded() {
        return MediaDriver.launchEmbedded(new Context());
    }

    public static MediaDriver launchEmbedded(Context ctx) {
        if (CommonContext.AERON_DIR_PROP_DEFAULT.equals(ctx.aeronDirectoryName())) {
            ctx.aeronDirectoryName(CommonContext.generateRandomDirName());
        }
        return MediaDriver.launch(ctx);
    }

    public static MediaDriver launch() {
        return MediaDriver.launch(new Context());
    }

    public static MediaDriver launch(Context ctx) {
        return new MediaDriver(ctx).start();
    }

    public Context context() {
        return this.ctx;
    }

    public AgentInvoker sharedAgentInvoker() {
        return this.sharedInvoker;
    }

    @Override
    public void close() {
        CloseHelper.quietClose((AutoCloseable)this.sharedRunner);
        CloseHelper.quietClose((AutoCloseable)this.sharedNetworkRunner);
        CloseHelper.quietClose((AutoCloseable)this.receiverRunner);
        CloseHelper.quietClose((AutoCloseable)this.senderRunner);
        CloseHelper.quietClose((AutoCloseable)this.conductorRunner);
        CloseHelper.quietClose((AutoCloseable)this.sharedInvoker);
        if (this.ctx.useWindowsHighResTimer() && SystemUtil.osName().startsWith("win") && !this.wasHighResTimerEnabled) {
            HighResolutionTimer.disable();
        }
        this.ctx.close();
    }

    public String aeronDirectoryName() {
        return this.ctx.aeronDirectoryName();
    }

    private MediaDriver start() {
        if (this.ctx.useWindowsHighResTimer() && SystemUtil.osName().startsWith("win")) {
            this.wasHighResTimerEnabled = HighResolutionTimer.isEnabled();
            if (!this.wasHighResTimerEnabled) {
                HighResolutionTimer.enable();
            }
        }
        if (null != this.conductorRunner) {
            AgentRunner.startOnThread((AgentRunner)this.conductorRunner, (ThreadFactory)this.ctx.conductorThreadFactory());
        }
        if (null != this.senderRunner) {
            AgentRunner.startOnThread((AgentRunner)this.senderRunner, (ThreadFactory)this.ctx.senderThreadFactory());
        }
        if (null != this.receiverRunner) {
            AgentRunner.startOnThread((AgentRunner)this.receiverRunner, (ThreadFactory)this.ctx.receiverThreadFactory());
        }
        if (null != this.sharedNetworkRunner) {
            AgentRunner.startOnThread((AgentRunner)this.sharedNetworkRunner, (ThreadFactory)this.ctx.sharedNetworkThreadFactory());
        }
        if (null != this.sharedRunner) {
            AgentRunner.startOnThread((AgentRunner)this.sharedRunner, (ThreadFactory)this.ctx.sharedThreadFactory());
        }
        if (null != this.sharedInvoker) {
            this.sharedInvoker.start();
        }
        return this;
    }

    private static void ensureDirectoryIsRecreated(Context ctx) {
        if (ctx.aeronDirectory().isDirectory()) {
            if (ctx.warnIfDirectoryExists()) {
                System.err.println("WARNING: " + ctx.aeronDirectory() + " already exists.");
            }
            if (!ctx.dirDeleteOnStart()) {
                Consumer<String> logger = ctx.warnIfDirectoryExists() ? System.err::println : s -> {};
                MappedByteBuffer cncByteBuffer = ctx.mapExistingCncFile(logger);
                try {
                    if (CommonContext.isDriverActive((long)ctx.driverTimeoutMs(), logger, (ByteBuffer)cncByteBuffer)) {
                        throw new ActiveDriverException("active driver detected");
                    }
                    MediaDriver.reportExistingErrors(ctx, cncByteBuffer);
                }
                finally {
                    IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
                }
            }
            ctx.deleteAeronDirectory();
        }
        IoUtil.ensureDirectoryExists((File)ctx.aeronDirectory(), (String)"aeron");
    }

    private static void reportExistingErrors(Context ctx, MappedByteBuffer cncByteBuffer) {
        block15: {
            try {
                int lastCharIndex;
                char c;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int observations = ctx.saveErrorLog(new PrintStream((OutputStream)baos, false, "UTF-8"), cncByteBuffer);
                if (observations <= 0) break block15;
                StringBuilder builder = new StringBuilder(ctx.aeronDirectoryName().length());
                while (builder.length() > 1 && ('/' == (c = builder.charAt(lastCharIndex = builder.length() - 1)) || '\\' == c)) {
                    builder.setLength(lastCharIndex);
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSSZ");
                builder.append(dateFormat.format(new Date())).append("-error.log");
                String errorLogFilename = builder.toString();
                System.err.println("WARNING: Existing errors saved to: " + errorLogFilename);
                try (FileOutputStream out = new FileOutputStream(errorLogFilename);){
                    baos.writeTo(out);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
    }

    public static class Context
    extends CommonContext {
        private boolean useWindowsHighResTimer = Configuration.USE_WINDOWS_HIGH_RES_TIMER;
        private boolean warnIfDirectoryExists = Configuration.DIR_WARN_IF_EXISTS;
        private boolean dirDeleteOnStart = Configuration.DIR_DELETE_ON_START;
        private boolean termBufferSparseFile = Configuration.TERM_BUFFER_SPARSE_FILE;
        private boolean performStorageChecks = Configuration.PERFORM_STORAGE_CHECKS;
        private boolean spiesSimulateConnection = Configuration.SPIES_SIMULATE_CONNECTION;
        private long timerIntervalNs = Configuration.TIMER_INTERVAL_NS;
        private long clientLivenessTimeoutNs = Configuration.CLIENT_LIVENESS_TIMEOUT_NS;
        private long imageLivenessTimeoutNs = Configuration.IMAGE_LIVENESS_TIMEOUT_NS;
        private long publicationUnblockTimeoutNs = Configuration.PUBLICATION_UNBLOCK_TIMEOUT_NS;
        private long publicationConnectionTimeoutNs = Configuration.PUBLICATION_CONNECTION_TIMEOUT_NS;
        private long publicationLingerTimeoutNs = Configuration.PUBLICATION_LINGER_NS;
        private long statusMessageTimeoutNs = Configuration.statusMessageTimeout();
        private long counterFreeToReuseTimeoutNs = Configuration.counterFreeToReuseTimeout();
        private int publicationTermBufferLength = Configuration.termBufferLength();
        private int ipcPublicationTermBufferLength = Configuration.ipcTermBufferLength(this.publicationTermBufferLength);
        private int initialWindowLength = Configuration.initialWindowLength();
        private int mtuLength = Configuration.MTU_LENGTH;
        private int ipcMtuLength = Configuration.IPC_MTU_LENGTH;
        private int filePageSize = Configuration.FILE_PAGE_SIZE;
        private int publicationReservedSessionIdLow = Configuration.PUBLICATION_RESERVED_SESSION_ID_LOW;
        private int publicationReservedSessionIdHigh = Configuration.PUBLICATION_RESERVED_SESSION_ID_HIGH;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private CachedEpochClock cachedEpochClock;
        private CachedNanoClock cachedNanoClock;
        private ThreadingMode threadingMode = Configuration.THREADING_MODE_DEFAULT;
        private ThreadFactory conductorThreadFactory;
        private ThreadFactory senderThreadFactory;
        private ThreadFactory receiverThreadFactory;
        private ThreadFactory sharedThreadFactory;
        private ThreadFactory sharedNetworkThreadFactory;
        private IdleStrategy conductorIdleStrategy;
        private IdleStrategy senderIdleStrategy;
        private IdleStrategy receiverIdleStrategy;
        private IdleStrategy sharedNetworkIdleStrategy;
        private IdleStrategy sharedIdleStrategy;
        private SendChannelEndpointSupplier sendChannelEndpointSupplier;
        private ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier;
        private ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals;
        private MutableDirectBuffer tempBuffer;
        private FlowControlSupplier unicastFlowControlSupplier;
        private FlowControlSupplier multicastFlowControlSupplier;
        private byte[] applicationSpecificFeedback = Configuration.SM_APPLICATION_SPECIFIC_FEEDBACK;
        private CongestionControlSupplier congestionControlSupplier;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private boolean useConcurrentCountersManager;
        private CountersManager countersManager;
        private SystemCounters systemCounters;
        private LossReport lossReport;
        private RawLogFactory rawLogFactory;
        private DataTransportPoller dataTransportPoller;
        private ControlTransportPoller controlTransportPoller;
        private ManyToOneConcurrentArrayQueue<Runnable> driverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue;
        private ReceiverProxy receiverProxy;
        private SenderProxy senderProxy;
        private DriverConductorProxy driverConductorProxy;
        private ClientProxy clientProxy;
        private RingBuffer toDriverCommands;
        private MappedByteBuffer lossReportBuffer;
        private MappedByteBuffer cncByteBuffer;
        private UnsafeBuffer cncMetaDataBuffer;

        public Context clone() {
            return (Context)super.clone();
        }

        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
            IoUtil.unmap((MappedByteBuffer)this.lossReportBuffer);
            super.close();
        }

        public Context conclude() {
            super.conclude();
            try {
                this.concludeNullProperties();
                Configuration.validateMtuLength(this.mtuLength);
                Configuration.validateMtuLength(this.ipcMtuLength);
                Configuration.validatePageSize(this.filePageSize);
                Context.validateSessionIdRange(this.publicationReservedSessionIdLow, this.publicationReservedSessionIdHigh);
                LogBufferDescriptor.checkTermLength((int)this.publicationTermBufferLength);
                LogBufferDescriptor.checkTermLength((int)this.ipcPublicationTermBufferLength);
                Configuration.validateInitialWindowLength(this.initialWindowLength, this.mtuLength);
                this.cncByteBuffer = IoUtil.mapNewFile((File)this.cncFile(), (long)CncFileDescriptor.computeCncFileLength((int)(Configuration.CONDUCTOR_BUFFER_LENGTH + Configuration.TO_CLIENTS_BUFFER_LENGTH + Configuration.COUNTERS_METADATA_BUFFER_LENGTH + Configuration.COUNTERS_VALUES_BUFFER_LENGTH + Configuration.ERROR_BUFFER_LENGTH), (int)this.filePageSize));
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)this.cncByteBuffer);
                CncFileDescriptor.fillMetaData((UnsafeBuffer)this.cncMetaDataBuffer, (int)Configuration.CONDUCTOR_BUFFER_LENGTH, (int)Configuration.TO_CLIENTS_BUFFER_LENGTH, (int)Configuration.COUNTERS_METADATA_BUFFER_LENGTH, (int)Configuration.COUNTERS_VALUES_BUFFER_LENGTH, (long)this.clientLivenessTimeoutNs, (int)Configuration.ERROR_BUFFER_LENGTH, (long)this.epochClock.time(), (long)SystemUtil.getPid());
                this.concludeCounters();
                this.concludeDependantProperties();
                this.concludeIdleStrategies();
                this.toDriverCommands.consumerHeartbeatTime(this.epochClock.time());
                CncFileDescriptor.signalCncReady((UnsafeBuffer)this.cncMetaDataBuffer);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            return this;
        }

        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        public Context countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
            super.countersMetaDataBuffer(countersMetaDataBuffer);
            return this;
        }

        public Context countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
            super.countersValuesBuffer(countersValuesBuffer);
            return this;
        }

        public Context useWindowsHighResTimer(boolean useWindowsHighResTimers) {
            this.useWindowsHighResTimer = useWindowsHighResTimers;
            return this;
        }

        public boolean useWindowsHighResTimer() {
            return this.useWindowsHighResTimer;
        }

        public boolean warnIfDirectoryExists() {
            return this.warnIfDirectoryExists;
        }

        public Context warnIfDirectoryExists(boolean warnIfDirectoryExists) {
            this.warnIfDirectoryExists = warnIfDirectoryExists;
            return this;
        }

        public boolean dirDeleteOnStart() {
            return this.dirDeleteOnStart;
        }

        public Context dirDeleteOnStart(boolean dirDeleteOnStart) {
            this.dirDeleteOnStart = dirDeleteOnStart;
            return this;
        }

        public boolean termBufferSparseFile() {
            return this.termBufferSparseFile;
        }

        public Context termBufferSparseFile(boolean termBufferSparseFile) {
            this.termBufferSparseFile = termBufferSparseFile;
            return this;
        }

        public boolean performStorageChecks() {
            return this.performStorageChecks;
        }

        public Context performStorageChecks(boolean performStorageChecks) {
            this.performStorageChecks = performStorageChecks;
            return this;
        }

        public int filePageSize() {
            return this.filePageSize;
        }

        public Context filePageSize(int filePageSize) {
            this.filePageSize = filePageSize;
            return this;
        }

        public long timerIntervalNs() {
            return this.timerIntervalNs;
        }

        public Context timerIntervalNs(long timerIntervalNs) {
            this.timerIntervalNs = timerIntervalNs;
            return this;
        }

        public long imageLivenessTimeoutNs() {
            return this.imageLivenessTimeoutNs;
        }

        public Context imageLivenessTimeoutNs(long timeout) {
            this.imageLivenessTimeoutNs = timeout;
            return this;
        }

        public long publicationLingerTimeoutNs() {
            return this.publicationLingerTimeoutNs;
        }

        public Context publicationLingerTimeoutNs(long timeoutNs) {
            this.publicationLingerTimeoutNs = timeoutNs;
            return this;
        }

        public long clientLivenessTimeoutNs() {
            return this.clientLivenessTimeoutNs;
        }

        public Context clientLivenessTimeoutNs(long timeoutNs) {
            this.clientLivenessTimeoutNs = timeoutNs;
            return this;
        }

        public long statusMessageTimeoutNs() {
            return this.statusMessageTimeoutNs;
        }

        public Context statusMessageTimeoutNs(long statusMessageTimeoutNs) {
            this.statusMessageTimeoutNs = statusMessageTimeoutNs;
            return this;
        }

        public long counterFreeToReuseTimeoutNs() {
            return this.counterFreeToReuseTimeoutNs;
        }

        public Context counterFreeToReuseTimeoutNs(long counterFreeToReuseTimeoutNs) {
            this.counterFreeToReuseTimeoutNs = counterFreeToReuseTimeoutNs;
            return this;
        }

        public long publicationUnblockTimeoutNs() {
            return this.publicationUnblockTimeoutNs;
        }

        public Context publicationUnblockTimeoutNs(long timeoutNs) {
            this.publicationUnblockTimeoutNs = timeoutNs;
            return this;
        }

        public long publicationConnectionTimeoutNs() {
            return this.publicationConnectionTimeoutNs;
        }

        public Context publicationConnectionTimeoutNs(long timeoutNs) {
            this.publicationConnectionTimeoutNs = timeoutNs;
            return this;
        }

        public boolean spiesSimulateConnection() {
            return this.spiesSimulateConnection;
        }

        public Context spiesSimulateConnection(boolean spiesSimulateConnection) {
            this.spiesSimulateConnection = spiesSimulateConnection;
            return this;
        }

        public int publicationTermBufferLength() {
            return this.publicationTermBufferLength;
        }

        public Context publicationTermBufferLength(int termBufferLength) {
            this.publicationTermBufferLength = termBufferLength;
            return this;
        }

        public int ipcTermBufferLength() {
            return this.ipcPublicationTermBufferLength;
        }

        public Context ipcTermBufferLength(int termBufferLength) {
            this.ipcPublicationTermBufferLength = termBufferLength;
            return this;
        }

        public int initialWindowLength() {
            return this.initialWindowLength;
        }

        public Context initialWindowLength(int initialWindowLength) {
            this.initialWindowLength = initialWindowLength;
            return this;
        }

        public int mtuLength() {
            return this.mtuLength;
        }

        public Context mtuLength(int mtuLength) {
            this.mtuLength = mtuLength;
            return this;
        }

        public int ipcMtuLength() {
            return this.ipcMtuLength;
        }

        public Context ipcMtuLength(int ipcMtuLength) {
            this.ipcMtuLength = ipcMtuLength;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public CachedEpochClock cachedEpochClock() {
            return this.cachedEpochClock;
        }

        public Context cachedEpochClock(CachedEpochClock clock) {
            this.cachedEpochClock = clock;
            return this;
        }

        public CachedNanoClock cachedNanoClock() {
            return this.cachedNanoClock;
        }

        public Context cachedNanoClock(CachedNanoClock clock) {
            this.cachedNanoClock = clock;
            return this;
        }

        public ThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory senderThreadFactory() {
            return this.senderThreadFactory;
        }

        public Context senderThreadFactory(ThreadFactory factory) {
            this.senderThreadFactory = factory;
            return this;
        }

        public ThreadFactory receiverThreadFactory() {
            return this.receiverThreadFactory;
        }

        public Context receiverThreadFactory(ThreadFactory factory) {
            this.receiverThreadFactory = factory;
            return this;
        }

        public ThreadFactory conductorThreadFactory() {
            return this.conductorThreadFactory;
        }

        public Context conductorThreadFactory(ThreadFactory factory) {
            this.conductorThreadFactory = factory;
            return this;
        }

        public ThreadFactory sharedThreadFactory() {
            return this.sharedThreadFactory;
        }

        public Context sharedThreadFactory(ThreadFactory factory) {
            this.sharedThreadFactory = factory;
            return this;
        }

        public ThreadFactory sharedNetworkThreadFactory() {
            return this.sharedNetworkThreadFactory;
        }

        public Context sharedNetworkThreadFactory(ThreadFactory factory) {
            this.sharedNetworkThreadFactory = factory;
            return this;
        }

        public IdleStrategy senderIdleStrategy() {
            return this.senderIdleStrategy;
        }

        public Context senderIdleStrategy(IdleStrategy strategy) {
            this.senderIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy receiverIdleStrategy() {
            return this.receiverIdleStrategy;
        }

        public Context receiverIdleStrategy(IdleStrategy strategy) {
            this.receiverIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy conductorIdleStrategy() {
            return this.conductorIdleStrategy;
        }

        public Context conductorIdleStrategy(IdleStrategy strategy) {
            this.conductorIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy sharedNetworkIdleStrategy() {
            return this.sharedNetworkIdleStrategy;
        }

        public Context sharedNetworkIdleStrategy(IdleStrategy strategy) {
            this.sharedNetworkIdleStrategy = strategy;
            return this;
        }

        public IdleStrategy sharedIdleStrategy() {
            return this.sharedIdleStrategy;
        }

        public Context sharedIdleStrategy(IdleStrategy strategy) {
            this.sharedIdleStrategy = strategy;
            return this;
        }

        public SendChannelEndpointSupplier sendChannelEndpointSupplier() {
            return this.sendChannelEndpointSupplier;
        }

        public Context sendChannelEndpointSupplier(SendChannelEndpointSupplier supplier) {
            this.sendChannelEndpointSupplier = supplier;
            return this;
        }

        public ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
            return this.receiveChannelEndpointSupplier;
        }

        public Context receiveChannelEndpointSupplier(ReceiveChannelEndpointSupplier supplier) {
            this.receiveChannelEndpointSupplier = supplier;
            return this;
        }

        public ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals() {
            return this.receiveChannelEndpointThreadLocals;
        }

        public Context receiveChannelEndpointThreadLocals(ReceiveChannelEndpointThreadLocals threadLocals) {
            this.receiveChannelEndpointThreadLocals = threadLocals;
            return this;
        }

        public MutableDirectBuffer tempBuffer() {
            return this.tempBuffer;
        }

        public Context tempBuffer(MutableDirectBuffer tempBuffer) {
            this.tempBuffer = tempBuffer;
            return this;
        }

        public FlowControlSupplier unicastFlowControlSupplier() {
            return this.unicastFlowControlSupplier;
        }

        public Context unicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.unicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public FlowControlSupplier multicastFlowControlSupplier() {
            return this.multicastFlowControlSupplier;
        }

        public Context multicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.multicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public byte[] applicationSpecificFeedback() {
            return this.applicationSpecificFeedback;
        }

        public Context applicationSpecificFeedback(byte[] asfBytes) {
            this.applicationSpecificFeedback = asfBytes;
            return this;
        }

        public CongestionControlSupplier congestionControlSupplier() {
            return this.congestionControlSupplier;
        }

        public Context congestControlSupplier(CongestionControlSupplier supplier) {
            this.congestionControlSupplier = supplier;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public boolean useConcurrentCountersManager() {
            return this.useConcurrentCountersManager;
        }

        public Context useConcurrentCountersManager(boolean useConcurrentCountersManager) {
            this.useConcurrentCountersManager = useConcurrentCountersManager;
            return this;
        }

        public CountersManager countersManager() {
            return this.countersManager;
        }

        public Context countersManager(CountersManager countersManager) {
            this.countersManager = countersManager;
            return this;
        }

        public SystemCounters systemCounters() {
            return this.systemCounters;
        }

        public Context systemCounters(SystemCounters systemCounters) {
            this.systemCounters = systemCounters;
            return this;
        }

        public LossReport lossReport() {
            return this.lossReport;
        }

        public Context lossReport(LossReport lossReport) {
            this.lossReport = lossReport;
            return this;
        }

        public int publicationReservedSessionIdLow() {
            return this.publicationReservedSessionIdLow;
        }

        public Context publicationReservedSessionIdLow(int sessionId) {
            this.publicationReservedSessionIdLow = sessionId;
            return this;
        }

        public int publicationReservedSessionIdHigh() {
            return this.publicationReservedSessionIdHigh;
        }

        public Context publicationReservedSessionIdHigh(int sessionId) {
            this.publicationReservedSessionIdHigh = sessionId;
            return this;
        }

        OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue() {
            return this.receiverCommandQueue;
        }

        Context receiverCommandQueue(OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue) {
            this.receiverCommandQueue = receiverCommandQueue;
            return this;
        }

        OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue() {
            return this.senderCommandQueue;
        }

        Context senderCommandQueue(OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue) {
            this.senderCommandQueue = senderCommandQueue;
            return this;
        }

        ManyToOneConcurrentArrayQueue<Runnable> driverCommandQueue() {
            return this.driverCommandQueue;
        }

        Context driverCommandQueue(ManyToOneConcurrentArrayQueue<Runnable> queue) {
            this.driverCommandQueue = queue;
            return this;
        }

        ClientProxy clientProxy() {
            return this.clientProxy;
        }

        Context clientProxy(ClientProxy clientProxy) {
            this.clientProxy = clientProxy;
            return this;
        }

        RingBuffer toDriverCommands() {
            return this.toDriverCommands;
        }

        Context toDriverCommands(RingBuffer toDriverCommands) {
            this.toDriverCommands = toDriverCommands;
            return this;
        }

        RawLogFactory rawLogBuffersFactory() {
            return this.rawLogFactory;
        }

        Context rawLogBuffersFactory(RawLogFactory rawLogFactory) {
            this.rawLogFactory = rawLogFactory;
            return this;
        }

        DataTransportPoller dataTransportPoller() {
            return this.dataTransportPoller;
        }

        Context dataTransportPoller(DataTransportPoller transportPoller) {
            this.dataTransportPoller = transportPoller;
            return this;
        }

        ControlTransportPoller controlTransportPoller() {
            return this.controlTransportPoller;
        }

        Context controlTransportPoller(ControlTransportPoller transportPoller) {
            this.controlTransportPoller = transportPoller;
            return this;
        }

        ReceiverProxy receiverProxy() {
            return this.receiverProxy;
        }

        Context receiverProxy(ReceiverProxy receiverProxy) {
            this.receiverProxy = receiverProxy;
            return this;
        }

        SenderProxy senderProxy() {
            return this.senderProxy;
        }

        Context senderProxy(SenderProxy senderProxy) {
            this.senderProxy = senderProxy;
            return this;
        }

        DriverConductorProxy driverConductorProxy() {
            return this.driverConductorProxy;
        }

        Context driverConductorProxy(DriverConductorProxy driverConductorProxy) {
            this.driverConductorProxy = driverConductorProxy;
            return this;
        }

        private void concludeNullProperties() {
            if (null == this.tempBuffer) {
                this.tempBuffer = new UnsafeBuffer(new byte[512]);
            }
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
            if (null == this.nanoClock) {
                this.nanoClock = new SystemNanoClock();
            }
            if (null == this.cachedEpochClock) {
                this.cachedEpochClock = new CachedEpochClock();
            }
            if (null == this.cachedNanoClock) {
                this.cachedNanoClock = new CachedNanoClock();
            }
            if (null == this.unicastFlowControlSupplier) {
                this.unicastFlowControlSupplier = Configuration.unicastFlowControlSupplier();
            }
            if (null == this.multicastFlowControlSupplier) {
                this.multicastFlowControlSupplier = Configuration.multicastFlowControlSupplier();
            }
            if (null == this.sendChannelEndpointSupplier) {
                this.sendChannelEndpointSupplier = Configuration.sendChannelEndpointSupplier();
            }
            if (null == this.receiveChannelEndpointSupplier) {
                this.receiveChannelEndpointSupplier = Configuration.receiveChannelEndpointSupplier();
            }
            if (null == this.dataTransportPoller) {
                this.dataTransportPoller = new DataTransportPoller();
            }
            if (null == this.controlTransportPoller) {
                this.controlTransportPoller = new ControlTransportPoller();
            }
            if (null == this.conductorThreadFactory) {
                this.conductorThreadFactory = Thread::new;
            }
            if (null == this.senderThreadFactory) {
                this.senderThreadFactory = Thread::new;
            }
            if (null == this.receiverThreadFactory) {
                this.receiverThreadFactory = Thread::new;
            }
            if (null == this.sharedThreadFactory) {
                this.sharedThreadFactory = Thread::new;
            }
            if (null == this.sharedNetworkThreadFactory) {
                this.sharedNetworkThreadFactory = Thread::new;
            }
            if (null == this.receiveChannelEndpointThreadLocals) {
                this.receiveChannelEndpointThreadLocals = new ReceiveChannelEndpointThreadLocals(this);
            }
            if (null == this.congestionControlSupplier) {
                this.congestionControlSupplier = Configuration.congestionControlSupplier();
            }
            if (null == this.driverCommandQueue) {
                this.driverCommandQueue = new ManyToOneConcurrentArrayQueue(256);
            }
            if (null == this.receiverCommandQueue) {
                this.receiverCommandQueue = new OneToOneConcurrentArrayQueue(256);
            }
            if (null == this.senderCommandQueue) {
                this.senderCommandQueue = new OneToOneConcurrentArrayQueue(256);
            }
        }

        private void concludeDependantProperties() {
            this.clientProxy = new ClientProxy(new BroadcastTransmitter((AtomicBuffer)CncFileDescriptor.createToClientsBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer)));
            this.toDriverCommands = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog((AtomicBuffer)CncFileDescriptor.createErrorLogBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer), this.epochClock);
            }
            if (null == this.errorHandler) {
                this.errorHandler = new LoggingErrorHandler(this.errorLog);
            }
            this.receiverProxy = new ReceiverProxy(this.threadingMode, (Queue<Runnable>)this.receiverCommandQueue(), this.systemCounters.get(SystemCounterDescriptor.RECEIVER_PROXY_FAILS));
            this.senderProxy = new SenderProxy(this.threadingMode, (Queue<Runnable>)this.senderCommandQueue(), this.systemCounters.get(SystemCounterDescriptor.SENDER_PROXY_FAILS));
            this.driverConductorProxy = new DriverConductorProxy(this.threadingMode, (Queue<Runnable>)this.driverCommandQueue(), this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_PROXY_FAILS));
            if (null == this.rawLogFactory) {
                this.rawLogFactory = new RawLogFactory(this.aeronDirectoryName(), this.filePageSize, this.performStorageChecks, this.errorHandler);
            }
            if (null == this.lossReport) {
                this.lossReportBuffer = LossReportUtil.mapLossReport(this.aeronDirectoryName(), BitUtil.align((int)Configuration.LOSS_REPORT_BUFFER_LENGTH, (int)this.filePageSize));
                this.lossReport = new LossReport((AtomicBuffer)new UnsafeBuffer((ByteBuffer)this.lossReportBuffer));
            }
        }

        private void concludeCounters() {
            if (null == this.countersManager) {
                long reuseTimeoutMs;
                EpochClock clock;
                if (this.countersMetaDataBuffer() == null) {
                    this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                }
                if (this.countersValuesBuffer() == null) {
                    this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                }
                if (this.counterFreeToReuseTimeoutNs > 0L) {
                    clock = this.epochClock;
                    reuseTimeoutMs = Math.min(TimeUnit.NANOSECONDS.toMillis(this.counterFreeToReuseTimeoutNs), 1L);
                } else {
                    clock = () -> 0L;
                    reuseTimeoutMs = 0L;
                }
                this.countersManager = this.useConcurrentCountersManager ? new ConcurrentCountersManager((AtomicBuffer)this.countersMetaDataBuffer(), (AtomicBuffer)this.countersValuesBuffer(), StandardCharsets.US_ASCII, clock, reuseTimeoutMs) : new CountersManager((AtomicBuffer)this.countersMetaDataBuffer(), (AtomicBuffer)this.countersValuesBuffer(), StandardCharsets.US_ASCII, clock, reuseTimeoutMs);
            }
            if (null == this.systemCounters) {
                this.systemCounters = new SystemCounters(this.countersManager);
            }
        }

        private void concludeIdleStrategies() {
            UnsafeBufferStatusIndicator indicator = new UnsafeBufferStatusIndicator(this.countersManager.valuesBuffer(), SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id());
            switch (this.threadingMode) {
                case SHARED: {
                    if (null != this.sharedIdleStrategy) break;
                    this.sharedIdleStrategy = Configuration.sharedIdleStrategy((StatusIndicator)indicator);
                    break;
                }
                case DEDICATED: {
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy((StatusIndicator)indicator);
                    }
                    if (null == this.senderIdleStrategy) {
                        this.senderIdleStrategy = Configuration.senderIdleStrategy((StatusIndicator)indicator);
                    }
                    if (null != this.receiverIdleStrategy) break;
                    this.receiverIdleStrategy = Configuration.receiverIdleStrategy((StatusIndicator)indicator);
                    break;
                }
                case SHARED_NETWORK: {
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy((StatusIndicator)indicator);
                    }
                    if (null != this.sharedNetworkIdleStrategy) break;
                    this.sharedNetworkIdleStrategy = Configuration.sharedNetworkIdleStrategy((StatusIndicator)indicator);
                    break;
                }
            }
        }

        private static void validateSessionIdRange(int low, int high) {
            if (low > high) {
                throw new IllegalArgumentException("low session id value " + low + " must be <= high value " + high);
            }
            if (Math.abs((long)high - (long)low) > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("reserved range to too large");
            }
        }
    }
}

