/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;
import org.agrona.concurrent.UnsafeBuffer;

final class PublicationParams {
    long lingerTimeoutNs;
    long tag = -1L;
    int termLength;
    int mtuLength;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean isReplay = false;
    boolean hasSessionId = false;
    boolean isSessionIdTagged = false;
    boolean isSparse = false;

    private PublicationParams(MediaDriver.Context context, boolean isIpc) {
        this.termLength = isIpc ? context.ipcTermBufferLength() : context.publicationTermBufferLength();
        this.mtuLength = isIpc ? context.ipcMtuLength() : context.mtuLength();
        this.lingerTimeoutNs = context.publicationLingerTimeoutNs();
        this.isSparse = context.termBufferSparseFile();
    }

    private void getTag(ChannelUri channelUri, DriverConductor driverConductor) {
        String tagParam = channelUri.entityTag();
        if (null != tagParam) {
            long tag = Long.parseLong(tagParam);
            PublicationParams.validateTag(tag, driverConductor);
            this.tag = tag;
        }
    }

    private void getTermBufferLength(ChannelUri channelUri) {
        String termLengthParam = channelUri.get("term-length");
        if (null != termLengthParam) {
            int termLength = (int)SystemUtil.parseSize((String)"term-length", (String)termLengthParam);
            LogBufferDescriptor.checkTermLength((int)termLength);
            PublicationParams.validateTermLength(this, termLength);
            this.termLength = termLength;
        }
    }

    private void getMtuLength(ChannelUri channelUri) {
        String mtuParam = channelUri.get("mtu");
        if (null != mtuParam) {
            int mtuLength = (int)SystemUtil.parseSize((String)"mtu", (String)mtuParam);
            Configuration.validateMtuLength(mtuLength);
            PublicationParams.validateMtuLength(this, mtuLength);
            this.mtuLength = mtuLength;
        }
    }

    private void getLingerTimeoutNs(ChannelUri channelUri) {
        String lingerParam = channelUri.get("linger");
        if (null != lingerParam) {
            this.lingerTimeoutNs = SystemUtil.parseDuration((String)"linger", (String)lingerParam);
            Configuration.validatePublicationLingerTimeoutNs(this.lingerTimeoutNs, this.lingerTimeoutNs);
        }
    }

    private void getSessionId(ChannelUri channelUri, DriverConductor driverConductor) {
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            this.isSessionIdTagged = ChannelUri.isTagged((String)sessionIdStr);
            if (this.isSessionIdTagged) {
                NetworkPublication publication = driverConductor.findNetworkPublicationByTag(ChannelUri.getTag((String)sessionIdStr));
                if (null == publication) {
                    throw new IllegalArgumentException("session-id=" + sessionIdStr + " must reference a network publication");
                }
                this.sessionId = publication.sessionId();
                this.mtuLength = publication.mtuLength();
                this.termLength = publication.termBufferLength();
            } else {
                this.sessionId = Integer.parseInt(sessionIdStr);
            }
            this.hasSessionId = true;
        }
    }

    private void getSparse(ChannelUri channelUri) {
        String sparseStr = channelUri.get("sparse");
        if (null != sparseStr) {
            this.isSparse = "true".equals(sparseStr);
        }
    }

    static void validateMtuForMaxMessage(PublicationParams params, boolean isExclusive) {
        int maxMessageLength;
        int termLength = params.termLength;
        int n = maxMessageLength = isExclusive ? FrameDescriptor.computeExclusiveMaxMessageLength((int)termLength) : FrameDescriptor.computeMaxMessageLength((int)termLength);
        if (params.mtuLength > maxMessageLength) {
            throw new IllegalStateException("MTU greater than max message length for term length: mtu=" + params.mtuLength + " maxMessageLength=" + maxMessageLength + " termLength=" + termLength);
        }
    }

    static void validateTermLength(PublicationParams params, int explicitTermLength) {
        if (params.isSessionIdTagged && explicitTermLength != params.termLength) {
            throw new IllegalArgumentException("term-length=" + explicitTermLength + " does not match session-id tag value");
        }
    }

    static void validateMtuLength(PublicationParams params, int explicitMtuLength) {
        if (params.isSessionIdTagged && explicitMtuLength != params.mtuLength) {
            throw new IllegalArgumentException("mtu=" + explicitMtuLength + " does not match session-id tag value");
        }
    }

    static void confirmMatch(ChannelUri uri, PublicationParams params, RawLog rawLog, int existingSessionId) {
        int mtuLength = LogBufferDescriptor.mtuLength((UnsafeBuffer)rawLog.metaData());
        if (uri.containsKey("mtu") && mtuLength != params.mtuLength) {
            throw new IllegalStateException("Existing publication has different MTU length: existing=" + mtuLength + " requested=" + params.mtuLength);
        }
        if (uri.containsKey("term-length") && rawLog.termLength() != params.termLength) {
            throw new IllegalStateException("Existing publication has different term length: existing=" + rawLog.termLength() + " requested=" + params.termLength);
        }
        if (uri.containsKey("session-id") && params.sessionId != existingSessionId) {
            throw new IllegalStateException("Existing publication has different session id: existing=" + existingSessionId + " requested=" + params.sessionId);
        }
    }

    private static void validateTag(long tag, DriverConductor driverConductor) {
        if (-1L == tag) {
            throw new IllegalArgumentException("-1 tag is reserved");
        }
        if (null != driverConductor.findNetworkPublicationByTag(tag) || null != driverConductor.findIpcPublicationByTag(tag)) {
            throw new IllegalArgumentException(tag + " tag already in use");
        }
    }

    static PublicationParams getPublicationParams(MediaDriver.Context context, ChannelUri channelUri, DriverConductor driverConductor, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams(context, isIpc);
        params.getTag(channelUri, driverConductor);
        params.getSessionId(channelUri, driverConductor);
        params.getTermBufferLength(channelUri);
        params.getMtuLength(channelUri);
        params.getLingerTimeoutNs(channelUri);
        params.getSparse(channelUri);
        if (isExclusive) {
            int count = 0;
            String initialTermIdStr = channelUri.get("init-term-id");
            count = initialTermIdStr != null ? count + 1 : count;
            String termIdStr = channelUri.get("term-id");
            count = termIdStr != null ? count + 1 : count;
            String termOffsetStr = channelUri.get("term-offset");
            int n = count = termOffsetStr != null ? count + 1 : count;
            if (count > 0) {
                if (count < 3) {
                    throw new IllegalArgumentException("Params must be used as a complete set: init-term-id term-id term-offset");
                }
                params.initialTermId = Integer.parseInt(initialTermIdStr);
                params.termId = Integer.parseInt(termIdStr);
                params.termOffset = Integer.parseInt(termOffsetStr);
                if (params.termOffset > params.termLength) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
                }
                if (params.termOffset < 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be greater than zero");
                }
                if ((params.termOffset & 0x1F) != 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
                }
                params.isReplay = true;
            }
        }
        return params;
    }
}

