/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.MediaDriver;

class SubscriptionParams {
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasJoinPosition = false;
    boolean hasSessionId = false;
    boolean isReliable = true;
    boolean isSparse = true;

    SubscriptionParams() {
    }

    static SubscriptionParams getSubscriptionParams(ChannelUri channelUri, MediaDriver.Context context) {
        String sparseStr;
        SubscriptionParams params = new SubscriptionParams();
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            params.sessionId = Integer.parseInt(sessionIdStr);
            params.hasSessionId = true;
        }
        int count = 0;
        params.isReliable = !"false".equals(channelUri.get("reliable", "true"));
        String initialTermIdStr = channelUri.get("init-term-id");
        count = initialTermIdStr != null ? count + 1 : count;
        String termIdStr = channelUri.get("term-id");
        count = termIdStr != null ? count + 1 : count;
        String termOffsetStr = channelUri.get("term-offset");
        int n = count = termOffsetStr != null ? count + 1 : count;
        if (count > 0) {
            if (count < 3) {
                throw new IllegalArgumentException("Params must be used as a complete set: init-term-id term-id term-offset");
            }
            params.initialTermId = Integer.parseInt(initialTermIdStr);
            params.termId = Integer.parseInt(termIdStr);
            params.termOffset = Integer.parseInt(termOffsetStr);
            if (params.termOffset < 0) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be greater than zero");
            }
            if ((params.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
            }
            params.hasJoinPosition = true;
        }
        params.isSparse = null != (sparseStr = channelUri.get("sparse")) ? "true".equals(sparseStr) : context.termBufferSparseFile();
        return params;
    }
}

