/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.DestinationImageControlAddress;
import io.aeron.driver.media.ReceiveDestinationUdpTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.CloseHelper;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.NanoClock;

public class MultiRcvDestination
implements AutoCloseable {
    private static final ReceiveDestinationUdpTransport[] EMPTY_TRANSPORTS = new ReceiveDestinationUdpTransport[0];
    private final long destinationAddressTimeoutNs;
    private final NanoClock nanoClock;
    private ReceiveDestinationUdpTransport[] transports = EMPTY_TRANSPORTS;
    private int numDestinations = 0;

    public MultiRcvDestination(NanoClock nanoClock, long timeoutNs) {
        this.nanoClock = nanoClock;
        this.destinationAddressTimeoutNs = timeoutNs;
    }

    @Override
    public void close() {
        for (ReceiveDestinationUdpTransport transport : this.transports) {
            CloseHelper.close((AutoCloseable)transport);
        }
    }

    public int addDestination(ReceiveDestinationUdpTransport transport) {
        int index = this.transports.length;
        int length = this.transports.length;
        for (int i = 0; i < length; ++i) {
            if (null != this.transports[i]) continue;
            index = i;
            break;
        }
        this.transports = (ReceiveDestinationUdpTransport[])ArrayUtil.ensureCapacity((Object[])this.transports, (int)(index + 1));
        this.transports[index] = transport;
        ++this.numDestinations;
        return index;
    }

    public void removeDestination(int transportIndex) {
        this.transports[transportIndex] = null;
        --this.numDestinations;
    }

    public boolean hasDestination(int transportIndex) {
        return this.numDestinations > transportIndex && null != this.transports[transportIndex];
    }

    public ReceiveDestinationUdpTransport transport(int transportIndex) {
        return this.transports[transportIndex];
    }

    public int transport(UdpChannel udpChannel) {
        ReceiveDestinationUdpTransport[] transports = this.transports;
        int index = -1;
        int length = transports.length;
        for (int i = 0; i < length; ++i) {
            ReceiveDestinationUdpTransport transport = transports[i];
            if (null == transport || !transport.udpChannel().equals(udpChannel)) continue;
            index = i;
            break;
        }
        return index;
    }

    public int sendToAll(DestinationImageControlAddress[] controlAddresses, ByteBuffer buffer, int position, int bytesToSend) {
        int lastIndex;
        ReceiveDestinationUdpTransport[] transports = this.transports;
        long nowNs = this.nanoClock.nanoTime();
        int minBytesSent = bytesToSend;
        for (int i = lastIndex = controlAddresses.length - 1; i >= 0; --i) {
            ReceiveDestinationUdpTransport transport;
            DestinationImageControlAddress controlAddress = controlAddresses[i];
            if (null == controlAddress || null == (transport = transports[i]) || nowNs >= controlAddress.timeOfLastFrameNs + this.destinationAddressTimeoutNs) continue;
            buffer.position(position);
            minBytesSent = Math.min(minBytesSent, MultiRcvDestination.sendTo(transport, buffer, controlAddress.address));
        }
        return minBytesSent;
    }

    public static int sendTo(UdpChannelTransport transport, ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int remaining = buffer.remaining();
        int bytesSent = 0;
        try {
            if (null != transport && null != transport.sendDatagramChannel && transport.sendDatagramChannel.isOpen()) {
                transport.sendHook(buffer, remoteAddress);
                bytesSent = transport.sendDatagramChannel.send(buffer, remoteAddress);
            }
        }
        catch (IOException ex) {
            UdpChannelTransport.sendError(remaining, ex, remoteAddress);
        }
        return bytesSent;
    }
}

