/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.actuate.endpoint;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class AbstractQuickFixJEndpoint {
    private final Connector connector;
    private final SessionSettings sessionSettings;
    private final Sanitizer sanitizer;

    AbstractQuickFixJEndpoint(Connector connector, SessionSettings sessionSettings, Sanitizer sanitizer) {
        this.connector = connector;
        this.sessionSettings = sessionSettings;
        this.sanitizer = sanitizer;
    }

    @ReadOperation
    public Map<String, Properties> readProperties() {
        ConcurrentHashMap<String, Properties> reports = new ConcurrentHashMap<String, Properties>();
        this.connector.getSessions().forEach(sessionId -> {
            try {
                Properties p = new Properties();
                Optional.ofNullable(this.sessionSettings.getDefaultProperties()).ifPresent(properties -> properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> p.put(key, this.sanitizeProperty(String.valueOf(key), value)))));
                Optional.ofNullable(this.sessionSettings.getSessionProperties(sessionId)).ifPresent(properties -> properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> p.put(key, this.sanitizeProperty(String.valueOf(key), value)))));
                this.addSessionIdProperties((SessionID)sessionId).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> p.put(key, this.sanitizeProperty(String.valueOf(key), value))));
                reports.put(sessionId.toString(), p);
            }
            catch (ConfigError e) {
                throw new IllegalStateException(e);
            }
        });
        return reports;
    }

    private Object sanitizeProperty(String key, Object value) {
        return this.sanitizer.sanitize(new SanitizableData(null, key, value), false);
    }

    private Properties addSessionIdProperties(SessionID sessionID) {
        String sessionQualifier;
        String targetLocationID;
        String senderLocationID;
        Properties properties = new Properties();
        properties.put("BeginString", sessionID.getBeginString());
        properties.put("SenderCompID", sessionID.getSenderCompID());
        String senderSubID = sessionID.getSenderSubID();
        if (!senderSubID.equals("")) {
            properties.put("SenderSubID", senderSubID);
        }
        if (!(senderLocationID = sessionID.getSenderLocationID()).equals("")) {
            properties.put("SenderLocationID", senderLocationID);
        }
        properties.put("TargetCompID", sessionID.getTargetCompID());
        String targetSubID = sessionID.getTargetSubID();
        if (!targetSubID.equals("")) {
            properties.put("TargetSubID", targetSubID);
        }
        if (!(targetLocationID = sessionID.getTargetLocationID()).equals("")) {
            properties.put("TargetLocationID", targetLocationID);
        }
        if (!(sessionQualifier = sessionID.getSessionQualifier()).equals("")) {
            properties.put("Qualifier", sessionQualifier);
        }
        return properties;
    }
}

