/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure.client;

import io.allune.quickfixj.spring.boot.actuate.endpoint.QuickFixJClientEndpoint;
import io.allune.quickfixj.spring.boot.actuate.health.QuickFixJSessionHealthIndicator;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.client.QuickFixJClientAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import quickfix.Connector;
import quickfix.DefaultSessionScheduleFactory;
import quickfix.Initiator;
import quickfix.SessionScheduleFactory;
import quickfix.SessionSettings;

@AutoConfiguration
@AutoConfigureAfter(value={QuickFixJClientAutoConfiguration.class})
@ConditionalOnProperty(name={"quickfixj.client.actuator.enabled"}, havingValue="true")
public class QuickFixJClientActuatorAutoConfiguration {
    @Bean
    @ConditionalOnBean(name={"clientInitiator", "clientSessionSettings"})
    @ConditionalOnClass(value={Initiator.class, SessionSettings.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public QuickFixJClientEndpoint quickfixjClientEndpoint(Initiator clientInitiator, SessionSettings clientSessionSettings, Sanitizer clientActuatorSanitizer) {
        return new QuickFixJClientEndpoint(clientInitiator, clientSessionSettings, clientActuatorSanitizer);
    }

    @Bean
    @ConditionalOnBean(name={"clientInitiator", "clientSessionSettings"})
    @ConditionalOnClass(value={Initiator.class, SessionSettings.class})
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="quickfixjclient")
    public QuickFixJSessionHealthIndicator quickfixjClientSessionHealthIndicator(Initiator clientInitiator, SessionScheduleFactory sessionSchedule, SessionSettings clientSessionSettings) {
        return new QuickFixJSessionHealthIndicator((Connector)clientInitiator, sessionSchedule, clientSessionSettings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionScheduleFactory sessionSchedule() {
        return new DefaultSessionScheduleFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sanitizer clientActuatorSanitizer() {
        return new Sanitizer();
    }
}

