/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure.client;

import io.allune.quickfixj.spring.boot.starter.application.EventPublisherApplicationAdapter;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.QuickFixJBootProperties;
import io.allune.quickfixj.spring.boot.starter.connection.ConnectorManager;
import io.allune.quickfixj.spring.boot.starter.connection.SessionSettingsLocator;
import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import quickfix.Application;
import quickfix.CachedFileStoreFactory;
import quickfix.CompositeLogFactory;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.ExecutorFactory;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.NoopStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketInitiator;
import quickfix.ThreadedSocketInitiator;

@AutoConfiguration
@ConditionalOnMissingBean(name={"clientConnectorManager"})
@ConditionalOnProperty(name={"quickfixj.client.enabled"}, havingValue="true")
@ConditionalOnExpression(value="${quickfixj.server.enabled:false} == false")
@EnableConfigurationProperties(value={QuickFixJBootProperties.class})
public class QuickFixJClientAutoConfiguration {
    private static final String SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG = "quickfixj.client.config";
    private static final String QUICKFIXJ_CLIENT_CONFIG = "quickfixj-client.cfg";

    @Bean
    @ConditionalOnMissingBean
    public SessionSettings clientSessionSettings(SessionSettingsLocator sessionSettingsLocator, QuickFixJBootProperties properties) {
        if (StringUtils.isNotEmpty((CharSequence)properties.getClient().getConfigString())) {
            return sessionSettingsLocator.loadSettingsFromString(properties.getClient().getConfigString());
        }
        return sessionSettingsLocator.loadSettings(new String[]{properties.getClient().getConfig(), System.getProperty(SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG), "file:./quickfixj-client.cfg", "classpath:/quickfixj-client.cfg"});
    }

    @Bean
    @ConditionalOnMissingBean
    public Application clientApplication(ApplicationEventPublisher applicationEventPublisher) {
        return new EventPublisherApplicationAdapter(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageFactory clientMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public ExecutorFactory clientExecutorFactory(final @Qualifier(value="clientTaskExecutor") Executor clientTaskExecutor) {
        return new ExecutorFactory(){

            public Executor getLongLivedExecutor() {
                return clientTaskExecutor;
            }

            public Executor getShortLivedExecutor() {
                return clientTaskExecutor;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public Executor clientTaskExecutor(QuickFixJBootProperties properties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setQueueCapacity(properties.getClient().getConcurrent().getQueueCapacity());
        executor.setCorePoolSize(properties.getClient().getConcurrent().getCorePoolSize());
        executor.setMaxPoolSize(properties.getClient().getConcurrent().getMaxPoolSize());
        executor.setAllowCoreThreadTimeOut(properties.getClient().getConcurrent().isAllowCoreThreadTimeOut());
        executor.setKeepAliveSeconds(properties.getClient().getConcurrent().getKeepAliveSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(properties.getClient().getConcurrent().isWaitForTasksToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(properties.getClient().getConcurrent().getAwaitTerminationSeconds());
        executor.setThreadNamePrefix(properties.getClient().getConcurrent().getThreadNamePrefix());
        return executor;
    }

    @Bean
    public ConnectorManager clientConnectorManager(Initiator clientInitiator, QuickFixJBootProperties properties) {
        ConnectorManager connectorManager = new ConnectorManager((Connector)clientInitiator);
        if (properties.getClient() != null) {
            connectorManager.setAutoStartup(properties.getClient().isAutoStartup());
            connectorManager.setPhase(properties.getClient().getPhase());
            connectorManager.setForceDisconnect(properties.getClient().isForceDisconnect());
        }
        return connectorManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.client", name={"jmx-enabled"}, havingValue="true")
    @ConditionalOnSingleCandidate(value=Initiator.class)
    @ConditionalOnMissingBean
    public ObjectName clientInitiatorMBean(Initiator clientInitiator) {
        try {
            JmxExporter exporter = new JmxExporter();
            exporter.setRegistrationBehavior(2);
            return exporter.register((Connector)clientInitiator);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionSettingsLocator sessionSettingsLocator(ResourceLoader resourceLoader) {
        return new SessionSettingsLocator(resourceLoader);
    }

    @Configuration(proxyBeanMethods=false)
    public static class ThreadedSocketInitiatorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"enabled"}, havingValue="true")
        public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory, Optional<ExecutorFactory> clientExecutorFactory) throws ConfigError {
            ThreadedSocketInitiator socketInitiator = (ThreadedSocketInitiator)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)((ThreadedSocketInitiator.Builder)ThreadedSocketInitiator.newBuilder().withApplication(clientApplication)).withMessageStoreFactory(clientMessageStoreFactory)).withSettings(clientSessionSettings)).withLogFactory(clientLogFactory)).withMessageFactory(clientMessageFactory)).build();
            clientExecutorFactory.ifPresent(arg_0 -> ((ThreadedSocketInitiator)socketInitiator).setExecutorFactory(arg_0));
            return socketInitiator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class SocketInitiatorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client.concurrent", name={"enabled"}, havingValue="false", matchIfMissing=true)
        public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory, Optional<ExecutorFactory> clientExecutorFactory) throws ConfigError {
            SocketInitiator socketInitiator = (SocketInitiator)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)((SocketInitiator.Builder)SocketInitiator.newBuilder().withApplication(clientApplication)).withMessageStoreFactory(clientMessageStoreFactory)).withSettings(clientSessionSettings)).withLogFactory(clientLogFactory)).withMessageFactory(clientMessageFactory)).build();
            clientExecutorFactory.ifPresent(arg_0 -> ((SocketInitiator)socketInitiator).setExecutorFactory(arg_0));
            return socketInitiator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class CompositeLogFactoryConfiguration {
        CompositeLogFactoryConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="compositelog")
        public LogFactory clientLogFactory(List<LogFactory> logFactories) {
            if (logFactories == null || logFactories.isEmpty()) {
                throw new ConfigurationException("The CompositeLogFactory requires at least one LogFactory bean defined in your application");
            }
            return new CompositeLogFactory(logFactories.toArray(new LogFactory[0]));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ScreenLogFactoryConfiguration {
        ScreenLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="screen", matchIfMissing=true)
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new ScreenLogFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Slf4jLogFactoryConfiguration {
        Slf4jLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="slf4j")
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new SLF4JLogFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JdbcLogFactoryConfiguration {
        JdbcLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="jdbc")
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new JdbcLogFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class FileLogFactoryConfiguration {
        FileLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"log-factory"}, havingValue="file")
        public LogFactory clientLogFactory(SessionSettings clientSessionSettings) {
            return new FileLogFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SleepycatMessageStoreFactoryConfiguration {
        SleepycatMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="sleepycat")
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new SleepycatStoreFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class NoopMessageStoreFactoryConfiguration {
        NoopMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="noop")
        public MessageStoreFactory clientMessageStoreFactory() {
            return new NoopStoreFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MemoryMessageStoreFactoryConfiguration {
        MemoryMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="memory", matchIfMissing=true)
        public MessageStoreFactory clientMessageStoreFactory() {
            return new MemoryStoreFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JdbcMessageStoreFactoryConfiguration {
        JdbcMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="jdbc")
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new JdbcStoreFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class FileMessageStoreFactoryConfiguration {
        FileMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="file")
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new FileStoreFactory(clientSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class CachedFileMessageStoreFactoryConfiguration {
        CachedFileMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.client", name={"message-store-factory"}, havingValue="cachedfile")
        public MessageStoreFactory clientMessageStoreFactory(SessionSettings clientSessionSettings) {
            return new CachedFileStoreFactory(clientSessionSettings);
        }
    }
}

