/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure.server;

import io.allune.quickfixj.spring.boot.starter.application.EventPublisherApplicationAdapter;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.QuickFixJBootProperties;
import io.allune.quickfixj.spring.boot.starter.connection.ConnectorManager;
import io.allune.quickfixj.spring.boot.starter.connection.SessionSettingsLocator;
import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.CachedFileStoreFactory;
import quickfix.CompositeLogFactory;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.ExecutorFactory;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.NoopStoreFactory;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketAcceptor;
import quickfix.ThreadedSocketAcceptor;

@AutoConfiguration
@ConditionalOnMissingBean(name={"serverConnectorManager"})
@ConditionalOnProperty(name={"quickfixj.server.enabled"}, havingValue="true")
@ConditionalOnExpression(value="${quickfixj.client.enabled:false} == false")
@EnableConfigurationProperties(value={QuickFixJBootProperties.class})
public class QuickFixJServerAutoConfiguration {
    private static final String SYSTEM_VARIABLE_QUICKFIXJ_SERVER_CONFIG = "quickfixj.server.config";
    private static final String QUICKFIXJ_SERVER_CONFIG = "quickfixj-server.cfg";

    @Bean
    @ConditionalOnMissingBean
    public SessionSettings serverSessionSettings(SessionSettingsLocator sessionSettingsLocator, QuickFixJBootProperties properties) {
        if (StringUtils.isNotEmpty((CharSequence)properties.getServer().getConfigString())) {
            return sessionSettingsLocator.loadSettingsFromString(properties.getServer().getConfigString());
        }
        return sessionSettingsLocator.loadSettings(new String[]{properties.getServer().getConfig(), System.getProperty(SYSTEM_VARIABLE_QUICKFIXJ_SERVER_CONFIG), "file:./quickfixj-server.cfg", "classpath:/quickfixj-server.cfg"});
    }

    @Bean
    @ConditionalOnMissingBean
    public Application serverApplication(ApplicationEventPublisher applicationEventPublisher) {
        return new EventPublisherApplicationAdapter(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageFactory serverMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="quickfixj.server.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public ExecutorFactory serverExecutorFactory(final @Qualifier(value="serverTaskExecutor") Executor serverTaskExecutor) {
        return new ExecutorFactory(){

            public Executor getLongLivedExecutor() {
                return serverTaskExecutor;
            }

            public Executor getShortLivedExecutor() {
                return serverTaskExecutor;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.server.concurrent", name={"useDefaultExecutorFactory"}, havingValue="true")
    public Executor serverTaskExecutor(QuickFixJBootProperties properties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setQueueCapacity(properties.getServer().getConcurrent().getQueueCapacity());
        executor.setCorePoolSize(properties.getServer().getConcurrent().getCorePoolSize());
        executor.setMaxPoolSize(properties.getServer().getConcurrent().getMaxPoolSize());
        executor.setAllowCoreThreadTimeOut(properties.getServer().getConcurrent().isAllowCoreThreadTimeOut());
        executor.setKeepAliveSeconds(properties.getServer().getConcurrent().getKeepAliveSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(properties.getServer().getConcurrent().isWaitForTasksToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(properties.getServer().getConcurrent().getAwaitTerminationSeconds());
        executor.setThreadNamePrefix(properties.getServer().getConcurrent().getThreadNamePrefix());
        return executor;
    }

    @Bean
    public ConnectorManager serverConnectorManager(Acceptor serverAcceptor, QuickFixJBootProperties properties) {
        ConnectorManager connectorManager = new ConnectorManager((Connector)serverAcceptor);
        if (properties.getServer() != null) {
            connectorManager.setAutoStartup(properties.getServer().isAutoStartup());
            connectorManager.setPhase(properties.getServer().getPhase());
            connectorManager.setForceDisconnect(properties.getServer().isForceDisconnect());
        }
        return connectorManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.server", name={"jmx-enabled"}, havingValue="true")
    @ConditionalOnSingleCandidate(value=Acceptor.class)
    @ConditionalOnMissingBean
    public ObjectName serverAcceptorMBean(Acceptor serverAcceptor) {
        try {
            JmxExporter exporter = new JmxExporter();
            exporter.setRegistrationBehavior(2);
            return exporter.register((Connector)serverAcceptor);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionSettingsLocator sessionSettingsLocator(ResourceLoader resourceLoader) {
        return new SessionSettingsLocator(resourceLoader);
    }

    @Configuration(proxyBeanMethods=false)
    public static class ThreadedSocketAcceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server.concurrent", name={"enabled"}, havingValue="true")
        public Acceptor serverAcceptor(Application serverApplication, MessageStoreFactory serverMessageStoreFactory, SessionSettings serverSessionSettings, LogFactory serverLogFactory, MessageFactory serverMessageFactory, Optional<ExecutorFactory> serverExecutorFactory) throws ConfigError {
            ThreadedSocketAcceptor socketAcceptor = (ThreadedSocketAcceptor)((ThreadedSocketAcceptor.Builder)((ThreadedSocketAcceptor.Builder)((ThreadedSocketAcceptor.Builder)((ThreadedSocketAcceptor.Builder)((ThreadedSocketAcceptor.Builder)ThreadedSocketAcceptor.newBuilder().withApplication(serverApplication)).withMessageStoreFactory(serverMessageStoreFactory)).withSettings(serverSessionSettings)).withLogFactory(serverLogFactory)).withMessageFactory(serverMessageFactory)).build();
            serverExecutorFactory.ifPresent(arg_0 -> ((ThreadedSocketAcceptor)socketAcceptor).setExecutorFactory(arg_0));
            return socketAcceptor;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class SocketAcceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server.concurrent", name={"enabled"}, havingValue="false", matchIfMissing=true)
        public Acceptor serverAcceptor(Application serverApplication, MessageStoreFactory serverMessageStoreFactory, SessionSettings serverSessionSettings, LogFactory serverLogFactory, MessageFactory serverMessageFactory, Optional<ExecutorFactory> serverExecutorFactory) throws ConfigError {
            SocketAcceptor socketAcceptor = (SocketAcceptor)((SocketAcceptor.Builder)((SocketAcceptor.Builder)((SocketAcceptor.Builder)((SocketAcceptor.Builder)((SocketAcceptor.Builder)SocketAcceptor.newBuilder().withApplication(serverApplication)).withMessageStoreFactory(serverMessageStoreFactory)).withSettings(serverSessionSettings)).withLogFactory(serverLogFactory)).withMessageFactory(serverMessageFactory)).build();
            serverExecutorFactory.ifPresent(arg_0 -> ((SocketAcceptor)socketAcceptor).setExecutorFactory(arg_0));
            return socketAcceptor;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class CompositeLogFactoryConfiguration {
        CompositeLogFactoryConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnProperty(prefix="quickfixj.server", name={"log-factory"}, havingValue="compositelog")
        public LogFactory serverLogFactory(List<LogFactory> logFactories) {
            if (logFactories == null || logFactories.isEmpty()) {
                throw new ConfigurationException("The CompositeLogFactory requires at least one LogFactory bean defined in your application");
            }
            return new CompositeLogFactory(logFactories.toArray(new LogFactory[0]));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ScreenLogFactoryConfiguration {
        ScreenLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"log-factory"}, havingValue="screen", matchIfMissing=true)
        public LogFactory serverLogFactory(SessionSettings serverSessionSettings) {
            return new ScreenLogFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Slf4jLogFactoryConfiguration {
        Slf4jLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"log-factory"}, havingValue="slf4j")
        public LogFactory serverLogFactory(SessionSettings serverSessionSettings) {
            return new SLF4JLogFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JdbcLogFactoryConfiguration {
        JdbcLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"log-factory"}, havingValue="jdbc")
        public LogFactory serverLogFactory(SessionSettings serverSessionSettings) {
            return new JdbcLogFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class FileLogFactoryConfiguration {
        FileLogFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"log-factory"}, havingValue="file")
        public LogFactory serverLogFactory(SessionSettings serverSessionSettings) {
            return new FileLogFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SleepycatMessageStoreFactoryConfiguration {
        SleepycatMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="sleepycat")
        public MessageStoreFactory serverMessageStoreFactory(SessionSettings serverSessionSettings) {
            return new SleepycatStoreFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class NoopMessageStoreFactoryConfiguration {
        NoopMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="noop")
        public MessageStoreFactory serverMessageStoreFactory() {
            return new NoopStoreFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MemoryMessageStoreFactoryConfiguration {
        MemoryMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="memory", matchIfMissing=true)
        public MessageStoreFactory serverMessageStoreFactory() {
            return new MemoryStoreFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JdbcMessageStoreFactoryConfiguration {
        JdbcMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="jdbc")
        public MessageStoreFactory serverMessageStoreFactory(SessionSettings serverSessionSettings) {
            return new JdbcStoreFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class FileMessageStoreFactoryConfiguration {
        FileMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="file")
        public MessageStoreFactory serverMessageStoreFactory(SessionSettings serverSessionSettings) {
            return new FileStoreFactory(serverSessionSettings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class CachedFileMessageStoreFactoryConfiguration {
        CachedFileMessageStoreFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="quickfixj.server", name={"message-store-factory"}, havingValue="cachedfile")
        public MessageStoreFactory serverMessageStoreFactory(SessionSettings serverSessionSettings) {
            return new CachedFileStoreFactory(serverSessionSettings);
        }
    }
}

