/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request;

import io.apicurio.registry.auth.Auth;
import io.apicurio.registry.rest.client.request.BodyHandler;
import io.apicurio.registry.rest.client.request.ErrorHandler;
import io.apicurio.registry.rest.client.request.Request;
import io.apicurio.registry.utils.BooleanUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.authorization.client.util.HttpResponseException;

public class RequestHandler {
    private static final String BASE_PATH = "apis/registry/v2/";
    private final HttpClient client;
    private final String endpoint;
    private Auth auth;
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final ThreadLocal<Map<String, String>> requestHeaders = ThreadLocal.withInitial(Collections::emptyMap);

    public RequestHandler(String endpoint, Map<String, Object> configs, Auth auth) {
        Object disableAutoBasePathAppend;
        if (!((String)endpoint).endsWith("/")) {
            endpoint = (String)endpoint + "/";
        }
        if (!BooleanUtil.toBoolean((Object)(disableAutoBasePathAppend = configs.get("apicurio.registry.client.disable-auto-basepath-append"))) && !((String)endpoint).endsWith(BASE_PATH)) {
            endpoint = (String)endpoint + BASE_PATH;
        }
        HttpClient.Builder httpClientBuilder = RequestHandler.handleConfiguration(configs);
        this.endpoint = endpoint;
        this.auth = auth;
        this.client = httpClientBuilder.build();
    }

    private static HttpClient.Builder handleConfiguration(Map<String, Object> configs) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        clientBuilder.version(HttpClient.Version.HTTP_1_1);
        RequestHandler.addHeaders(configs);
        clientBuilder = RequestHandler.addSSL(clientBuilder, configs);
        return clientBuilder;
    }

    private static void addHeaders(Map<String, Object> configs) {
        Map<String, String> requestHeaders = configs.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith("apicurio.registry.request.headers.")).collect(Collectors.toMap(map -> ((String)map.getKey()).replace("apicurio.registry.request.headers.", ""), map -> map.getValue().toString()));
        if (!requestHeaders.isEmpty()) {
            requestHeaders.forEach(DEFAULT_HEADERS::put);
        }
    }

    private static HttpClient.Builder addSSL(HttpClient.Builder httpClientBuilder, Map<String, Object> configs) {
        try {
            KeyManager[] keyManagers = RequestHandler.getKeyManagers(configs);
            Object[] trustManagers = RequestHandler.getTrustManagers(configs);
            if (!(trustManagers == null || trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("A single X509TrustManager is expected. Unexpected trust managers: " + Arrays.toString(trustManagers));
            }
            if (keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(keyManagers, (TrustManager[])trustManagers, new SecureRandom());
                return httpClientBuilder.sslContext(sslContext);
            }
            return httpClientBuilder;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TrustManager[] getTrustManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        TrustManager[] trustManagers = null;
        if (configs.containsKey("apicurio.registry.request.ssl.truststore.location")) {
            String truststoreType = (String)configs.getOrDefault("apicurio.registry.request.ssl.truststore.type", "JKS");
            KeyStore truststore = KeyStore.getInstance(truststoreType);
            String truststorePwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.truststore.password", "");
            truststore.load(new FileInputStream((String)configs.get("apicurio.registry.request.ssl.truststore.location")), truststorePwd.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private static KeyManager[] getKeyManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (configs.containsKey("apicurio.registry.request.ssl.keystore.location")) {
            String keystoreType = (String)configs.getOrDefault("apicurio.registry.request.ssl.keystore.type", "JKS");
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            String keyStorePwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.keystore.password", "");
            keystore.load(new FileInputStream((String)configs.get("apicurio.registry.request.ssl.keystore.location")), keyStorePwd.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyPwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.key.password", keyStorePwd);
            keyManagerFactory.init(keystore, keyPwd.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        return keyManagers;
    }

    public <T> T sendRequest(Request<T> request) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(RequestHandler.buildURI(this.endpoint + request.getRequestPath(), request.getQueryParams(), request.getPathParams()));
            DEFAULT_HEADERS.forEach(requestBuilder::header);
            requestHeaders.get().forEach(requestBuilder::header);
            requestHeaders.remove();
            Map<String, String> headers = request.getHeaders();
            if (this.auth != null) {
                headers = new HashMap<String, String>(headers);
                this.auth.apply(headers);
            }
            headers.forEach(requestBuilder::header);
            switch (request.getOperation()) {
                case GET: {
                    requestBuilder.GET();
                    break;
                }
                case PUT: {
                    requestBuilder.PUT(HttpRequest.BodyPublishers.ofByteArray(request.getData().readAllBytes()));
                    break;
                }
                case POST: {
                    requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(request.getData().readAllBytes()));
                    break;
                }
                case DELETE: {
                    requestBuilder.DELETE();
                    break;
                }
                default: {
                    throw new IllegalStateException("Operation not allowed");
                }
            }
            return ((Supplier)this.client.send(requestBuilder.build(), new BodyHandler<T>(request.getResponseType())).body()).get();
        }
        catch (IOException | InterruptedException | URISyntaxException | HttpResponseException e) {
            throw ErrorHandler.parseError((Exception)e);
        }
    }

    private static URI buildURI(String basePath, Map<String, List<String>> queryParams, List<String> pathParams) throws URISyntaxException {
        Object[] encodedPathParams = pathParams.stream().map(RequestHandler::encodeURIComponent).toArray();
        URIBuilder uriBuilder = new URIBuilder(String.format(basePath, encodedPathParams));
        ArrayList queryParamsExpanded = new ArrayList();
        queryParams.forEach((key, paramList) -> paramList.forEach(value -> queryParamsExpanded.add(new BasicNameValuePair(key, value))));
        uriBuilder.setParameters(queryParamsExpanded);
        return uriBuilder.build();
    }

    private static String encodeURIComponent(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setNextRequestHeaders(Map<String, String> headers) {
        requestHeaders.set(headers);
    }

    public Map<String, String> getHeaders() {
        return requestHeaders.get();
    }
}

