/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.client.request.ErrorHandler;
import io.apicurio.registry.rest.client.request.Request;
import io.apicurio.registry.rest.client.request.provider.Operation;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminRequestsProvider {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Request<NamedLogConfiguration> removeLogConfiguration(String logger) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/loggers/%s").pathParams(List.of(logger)).responseType(new TypeReference<NamedLogConfiguration>(){}).build();
    }

    public static Request<NamedLogConfiguration> setLogConfiguration(String logger, LogConfiguration data) {
        try {
            return new Request.RequestBuilder().operation(Operation.PUT).path("admin/loggers/%s").pathParams(List.of(logger)).responseType(new TypeReference<NamedLogConfiguration>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
        }
        catch (JsonProcessingException e) {
            throw ErrorHandler.parseInputSerializingError(e);
        }
    }

    public static Request<NamedLogConfiguration> getLogConfiguration(String logger) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/loggers/%s").pathParams(List.of(logger)).responseType(new TypeReference<NamedLogConfiguration>(){}).build();
    }

    public static Request<List<NamedLogConfiguration>> listLogConfigurations() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/loggers").responseType(new TypeReference<List<NamedLogConfiguration>>(){}).build();
    }

    public static Request<Void> deleteGlobalRule(RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType(new TypeReference<Void>(){}).build();
    }

    public static Request<Rule> updateGlobalRuleConfig(RuleType rule, Rule data) {
        try {
            return new Request.RequestBuilder().operation(Operation.PUT).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType(new TypeReference<Rule>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
        }
        catch (JsonProcessingException e) {
            throw ErrorHandler.parseInputSerializingError(e);
        }
    }

    public static Request<Rule> getGlobalRule(RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType(new TypeReference<Rule>(){}).build();
    }

    public static Request<Void> deleteAllGlobalRules() {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/rules").responseType(new TypeReference<Void>(){}).build();
    }

    public static Request<Void> createGlobalRule(Rule data) {
        try {
            return new Request.RequestBuilder().operation(Operation.POST).path("admin/rules").data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType(new TypeReference<Void>(){}).build();
        }
        catch (JsonProcessingException e) {
            throw ErrorHandler.parseInputSerializingError(e);
        }
    }

    public static Request<List<RuleType>> listGlobalRules() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/rules").responseType(new TypeReference<List<RuleType>>(){}).build();
    }

    public static Request<InputStream> exportData() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/export").responseType(new TypeReference<InputStream>(){}).headers(new HashMap<String, String>(Map.of("Accept", "application/zip"))).build();
    }

    public static Request<Void> importData(InputStream data) {
        return new Request.RequestBuilder().operation(Operation.POST).path("admin/import").responseType(new TypeReference<Void>(){}).data(data).headers(new HashMap<String, String>(Map.of("Content-Type", "application/zip"))).build();
    }
}

