/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import io.apicurio.registry.utils.RegistryProperties;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class PropertiesUtil {
    public static Properties properties(RegistryProperties kp) {
        String prefix = kp != null ? kp.value() : "";
        Config config = ConfigProviderResolver.instance().getConfig();
        String profile = ProfileManager.getActiveProfile();
        if (profile != null && profile.length() > 0) {
            prefix = "%" + profile + "." + prefix;
        }
        HashMap<String, String> defaults = new HashMap<String, String>();
        if (kp != null) {
            String[] empties = kp.empties();
            for (String e : empties) {
                int p = e.indexOf("=");
                defaults.put(e.substring(0, p), e.substring(p + 1));
            }
        }
        Properties properties = new Properties();
        for (String key : config.getPropertyNames()) {
            String sKey;
            String defaultValue;
            if (!key.startsWith(prefix)) continue;
            Optional value = config.getOptionalValue(key, String.class);
            if (value.isPresent()) {
                properties.put(key.substring(prefix.length()), value.get());
                continue;
            }
            if (defaults.size() <= 0 || (defaultValue = (String)defaults.get(sKey = key.substring(prefix.length()))) == null) continue;
            properties.put(sKey, defaultValue);
        }
        return properties;
    }
}

