/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote.options;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class W3CCapabilityKeys
implements Predicate<String> {
    public static final W3CCapabilityKeys INSTANCE = new W3CCapabilityKeys();
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = Stream.of("^[\\w-]+:.*$", "^acceptInsecureCerts$", "^browserName$", "^browserVersion$", "^platformName$", "^pageLoadStrategy$", "^proxy$", "^setWindowRect$", "^strictFileInteractability$", "^timeouts$", "^unhandledPromptBehavior$", "^webSocketUrl$").map(Pattern::compile).map(Pattern::asPredicate).reduce(identity -> false, Predicate::or);

    protected W3CCapabilityKeys() {
    }

    @Override
    public boolean test(String capabilityName) {
        return ACCEPTED_W3C_PATTERNS.test(capabilityName);
    }
}

