/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.generator.license;

import io.atomicbits.scraml.generator.license.LicenseData;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import sun.misc.BASE64Decoder;

public final class LicenseVerifier$ {
    public static final LicenseVerifier$ MODULE$;
    private final String charset;
    private final String datePattern;
    private final String algorithm;
    private final String signatureAlgorithm;
    private final String freeLicenseStatementMandatoryPart;
    private final String freeLicenseStatementOfIntend;
    private final String publicKeyPEM;
    private volatile Map<String, Option<LicenseData>> validatedLicenses;
    private PublicKey publicKey;
    private volatile boolean bitmap$0;

    static {
        new LicenseVerifier$();
    }

    private PublicKey publicKey$lzycompute() {
        LicenseVerifier$ licenseVerifier$ = this;
        synchronized (licenseVerifier$) {
            if (!this.bitmap$0) {
                BASE64Decoder b64 = new BASE64Decoder();
                byte[] decoded = b64.decodeBuffer(this.publicKeyPEM());
                X509EncodedKeySpec spec = new X509EncodedKeySpec(decoded);
                KeyFactory kf = KeyFactory.getInstance(this.algorithm());
                this.publicKey = kf.generatePublic(spec);
                this.bitmap$0 = true;
            }
            return this.publicKey;
        }
    }

    public String charset() {
        return this.charset;
    }

    public String datePattern() {
        return this.datePattern;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String freeLicenseStatementMandatoryPart() {
        return this.freeLicenseStatementMandatoryPart;
    }

    public String freeLicenseStatementOfIntend() {
        return this.freeLicenseStatementOfIntend;
    }

    public String publicKeyPEM() {
        return this.publicKeyPEM;
    }

    private Map<String, Option<LicenseData>> validatedLicenses() {
        return this.validatedLicenses;
    }

    private void validatedLicenses_$eq(Map<String, Option<LicenseData>> x$1) {
        this.validatedLicenses = x$1;
    }

    public Option<LicenseData> validateLicense(String licenseKey) {
        Option option;
        block4: {
            Option option2;
            block3: {
                String cleanKey;
                block2: {
                    cleanKey = this.cleanCommercialLicenseKey(licenseKey);
                    option = this.validatedLicenses().get((Object)cleanKey);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Option optionalLicenseData = (Option)some.x();
                    option2 = optionalLicenseData.flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<LicenseData> apply(LicenseData licenseKey) {
                            return LicenseVerifier$.MODULE$.io$atomicbits$scraml$generator$license$LicenseVerifier$$checkExpiryDate(licenseKey);
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                option2 = this.decodeVerifyAndRegister(cleanKey);
            }
            return option2;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private Option<LicenseData> decodeVerifyAndRegister(String licenseKey) {
        void var2_2;
        Option decoded = this.decodeLicense(licenseKey).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<LicenseData> apply(LicenseData licenseKey) {
                return LicenseVerifier$.MODULE$.io$atomicbits$scraml$generator$license$LicenseVerifier$$checkExpiryDate(licenseKey);
            }
        });
        this.addValidatedLicense(licenseKey, (Option<LicenseData>)decoded);
        return var2_2;
    }

    private Option<LicenseData> decodeLicense(String licenseKey) {
        return this.decodeFreeLicense(licenseKey).orElse((Function0)new Serializable(licenseKey){
            public static final long serialVersionUID = 0L;
            private final String licenseKey$1;

            public final Option<LicenseData> apply() {
                return LicenseVerifier$.MODULE$.io$atomicbits$scraml$generator$license$LicenseVerifier$$decodeCommercialLicense(this.licenseKey$1);
            }
            {
                this.licenseKey$1 = licenseKey$1;
            }
        });
    }

    private Option<LicenseData> decodeFreeLicense(String licenseKey) {
        None$ none$;
        String cleanKey = this.cleanFreeLicenseKey(licenseKey);
        if (cleanKey.toLowerCase().contains(this.freeLicenseStatementMandatoryPart().toLowerCase())) {
            String userName = (String)this.getFreeLicenseKeyUser(cleanKey).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please state the free license intend as:\\n", "\\n and fill in your name between the commas."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LicenseVerifier$.MODULE$.freeLicenseStatementOfIntend()})));
                }
            });
            LicenseData licenseData = new LicenseData("-1", "-1", "Free", userName, -1L, LocalDate.now());
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Free Scraml license used by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{licenseData.owner()})));
            none$ = new Some((Object)licenseData);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<LicenseData> io$atomicbits$scraml$generator$license$LicenseVerifier$$decodeCommercialLicense(String licenseKey) {
        String encodedKey = licenseKey.trim();
        byte[] signedKeyBytes = (byte[])Try$.MODULE$.apply((Function0)new Serializable(encodedKey){
            public static final long serialVersionUID = 0L;
            private final String encodedKey$1;

            public final byte[] apply() {
                return new BASE64Decoder().decodeBuffer(this.encodedKey$1);
            }
            {
                this.encodedKey$1 = encodedKey$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot verify license key with bad key format."})).s((Seq)Nil$.MODULE$));
            }
        });
        String signedKey = new String(signedKeyBytes, this.charset());
        List list = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(signedKey)).split('!')).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String uKey = (String)colon2.head();
            List list2 = colon2.tl$1();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String sig = (String)colon3.head();
                Tuple2 tuple2 = new Tuple2((Object)uKey, (Object)sig);
                Tuple2 tuple22 = tuple2;
                if (tuple22 != null) {
                    None$ none$;
                    String signature;
                    String signature2;
                    String unsignedKey = (String)tuple22._1();
                    Tuple2 tuple23 = new Tuple2((Object)unsignedKey, (Object)(signature2 = (String)tuple22._2()));
                    Tuple2 tuple24 = tuple23;
                    String unsignedKey2 = (String)tuple24._1();
                    if (this.verifySignature(unsignedKey2, signature = (String)tuple24._2())) {
                        None$ none$2;
                        List list3 = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(unsignedKey2)).split(';')).toList();
                        Some some = List$.MODULE$.unapplySeq((Seq)list3);
                        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(6) == 0) {
                            String licenseType = (String)((LinearSeqOptimized)some.get()).apply(0);
                            String customerId = (String)((LinearSeqOptimized)some.get()).apply(1);
                            String licenseId = (String)((LinearSeqOptimized)some.get()).apply(2);
                            String owner = (String)((LinearSeqOptimized)some.get()).apply(3);
                            String purchaseDateString = (String)((LinearSeqOptimized)some.get()).apply(4);
                            String periodString = (String)((LinearSeqOptimized)some.get()).apply(5);
                            String x$2 = customerId;
                            String x$3 = licenseId;
                            String x$4 = owner;
                            String x$5 = licenseType;
                            long x$6 = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(periodString){
                                public static final long serialVersionUID = 0L;
                                private final String periodString$1;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return new StringOps(Predef$.MODULE$.augmentString(this.periodString$1)).toLong();
                                }
                                {
                                    this.periodString$1 = periodString$1;
                                }
                            }).getOrElse((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return 0L;
                                }
                            }));
                            LocalDate x$7 = (LocalDate)Try$.MODULE$.apply((Function0)new Serializable(purchaseDateString){
                                public static final long serialVersionUID = 0L;
                                private final String purchaseDateString$1;

                                public final LocalDate apply() {
                                    return LocalDate.parse(this.purchaseDateString$1, DateTimeFormatter.ofPattern(LicenseVerifier$.MODULE$.datePattern()));
                                }
                                {
                                    this.purchaseDateString$1 = purchaseDateString$1;
                                }
                            }).getOrElse((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final LocalDate apply() {
                                    return LocalDate.ofYearDay(1950, 1);
                                }
                            });
                            LicenseData licenseData = new LicenseData(x$2, x$3, x$5, x$4, x$6, x$7);
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scraml license ", " is licensed to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{licenseId, owner})));
                            none$2 = new Some((Object)licenseData);
                        } else {
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid license key. Falling back to default AGPL license."})).s((Seq)Nil$.MODULE$));
                            none$2 = None$.MODULE$;
                        }
                        none$ = none$2;
                    } else {
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid license key. Falling back to default AGPL license.\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{licenseKey})));
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }
                throw new MatchError((Object)tuple22);
            }
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot verify key with bad key format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signedKey})));
    }

    public Option<LicenseData> io$atomicbits$scraml$generator$license$LicenseVerifier$$checkExpiryDate(LicenseData licenseKey) {
        Some some;
        LocalDate today = LocalDate.now();
        LocalDate expiryDate = licenseKey.purchaseDate().plusDays(licenseKey.period());
        LocalDate warningDate = licenseKey.purchaseDate().plusDays(licenseKey.period() - 31L);
        if (licenseKey.period() < 0L) {
            some = new Some((Object)licenseKey);
        } else if (today.isAfter(expiryDate)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |\n           |Warning: your scraml license key expired on ", ".\n           |\n           |We will now fall back to the default AGPL license!\n           |\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expiryDate.format(DateTimeFormatter.ISO_DATE)})))).stripMargin());
            some = None$.MODULE$;
        } else if (today.isAfter(warningDate)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |\n           |Warning: your scraml license key expires on ", ".\n           |\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expiryDate.format(DateTimeFormatter.ISO_DATE)})))).stripMargin());
            some = new Some((Object)licenseKey);
        } else {
            some = new Some((Object)licenseKey);
        }
        return some;
    }

    private boolean verifySignature(String text, String signature) {
        byte[] textBytes = text.getBytes("UTF8");
        Signature signer = Signature.getInstance(this.signatureAlgorithm());
        signer.initVerify(this.publicKey());
        signer.update(textBytes);
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(signature, signer){
            public static final long serialVersionUID = 0L;
            private final String signature$1;
            private final Signature signer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.signer$1.verify(new BASE64Decoder().decodeBuffer(this.signature$1));
            }
            {
                this.signature$1 = signature$1;
                this.signer$1 = signer$1;
            }
        }).recover((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                Object object = option.isEmpty() ? function1.apply(x1) : BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
        }).get());
    }

    public PublicKey publicKey() {
        return this.bitmap$0 ? this.publicKey : this.publicKey$lzycompute();
    }

    private void addValidatedLicense(String licenseKey, Option<LicenseData> licenseData) {
        LicenseVerifier$ licenseVerifier$ = this;
        synchronized (licenseVerifier$) {
            this.validatedLicenses_$eq((Map<String, Option<LicenseData>>)this.validatedLicenses().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)licenseKey), licenseData)));
            return;
        }
    }

    private String cleanCommercialLicenseKey(String licenseKey) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(licenseKey)).split('\n')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String line) {
                return line.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    private String cleanFreeLicenseKey(String licenseKey) {
        return licenseKey.replaceAll("\\s+", " ");
    }

    private Option<String> getFreeLicenseKeyUser(String licenseKey) {
        None$ none$;
        .colon.colon colon2;
        List list;
        List list2 = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(licenseKey)).split(',')).toList();
        if (list2 instanceof .colon.colon && (list = (colon2 = (.colon.colon)list2).tl$1()) instanceof .colon.colon) {
            .colon.colon colon3 = (.colon.colon)list;
            String name = (String)colon3.head();
            none$ = new Some((Object)name.trim());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private LicenseVerifier$() {
        MODULE$ = this;
        this.charset = "UTF-8";
        this.datePattern = "yyyy-MM-dd";
        this.algorithm = "RSA";
        this.signatureAlgorithm = "SHA1WithRSA";
        this.freeLicenseStatementMandatoryPart = "use the free scraml license in this project without any intend to serve commercial purposes for ourselves or anyone else";
        this.freeLicenseStatementOfIntend = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<We/I>, <enter name here>, ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.freeLicenseStatementMandatoryPart()}));
        this.publicKeyPEM = new StringOps(Predef$.MODULE$.augmentString("\n      |MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7AhsLTLtb8uzz8ammZd3PScF/nyfevcM\n      |1tNSk8O9gQbwPszMrOAR9cxODm4owkhg4GU2ADlOSqGvTZJxKHqoUWkp5DazN3D/tex+88I58v/9\n      |8M61TJRGKrBV0q+TCudLswcDnLkw0WQpJUE4RgYKJoi4j1K9+R6L1c5/B6cdgaQrIurt52A9Jffj\n      |aJ4+tlSyNsSmR3w320+KYj5uG+NKSZcghIwzbIYSZkSS+hKfQIEPbAUY0hFWIL0PuEuEuRXxnJXQ\n      |6+tuQ04hfkJn9NVBFZPOIY+nw7nmzZnstbJsnCPW47Ple2Fyv6VV/jZlRyuE3P2VAn5p+8KPc2uH\n      |5SnYWQIDAQAB\n    ")).stripMargin().trim();
        this.validatedLicenses = Predef$.MODULE$.Map().empty();
    }
}

