/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer.util;

import io.atomix.catalyst.buffer.util.MemoryAllocator;

public interface Memory {
    public MemoryAllocator allocator();

    public long address();

    public long address(long var1);

    public long size();

    public byte getByte(long var1);

    public char getChar(long var1);

    public short getShort(long var1);

    public int getInt(long var1);

    public long getLong(long var1);

    public float getFloat(long var1);

    public double getDouble(long var1);

    public void putByte(long var1, byte var3);

    public void putChar(long var1, char var3);

    public void putShort(long var1, short var3);

    public void putInt(long var1, int var3);

    public void putLong(long var1, long var3);

    public void putFloat(long var1, float var3);

    public void putDouble(long var1, double var3);

    public Memory copy();

    public void clear();

    public void free();

    public static class Util {
        public static boolean isPow2(long size) {
            return size > 0L & (size & size - 1L) == 0L;
        }

        public static long toPow2(long size) {
            if ((size & size - 1L) == 0L) {
                return size;
            }
            int i = 128;
            while ((long)i < size) {
                if ((i *= 2) > 0) continue;
                return 0x4000000000000000L;
            }
            return i;
        }
    }
}

