/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.util;

import io.atomix.copycat.server.storage.entry.Entry;

public class EntryBuffer {
    private final Entry[] buffer;

    public EntryBuffer(int size) {
        this.buffer = new Entry[size];
    }

    public EntryBuffer append(Entry entry) {
        int offset = this.offset(entry.getIndex());
        Entry oldEntry = this.buffer[offset];
        this.buffer[offset] = entry.acquire();
        if (oldEntry != null) {
            oldEntry.release();
        }
        return this;
    }

    public <T extends Entry> T get(long index) {
        Entry entry = this.buffer[this.offset(index)];
        return (T)(entry != null && entry.getIndex() == index ? entry.acquire() : null);
    }

    public EntryBuffer clear() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        return this;
    }

    private int offset(long index) {
        int offset = (int)(index % (long)this.buffer.length);
        if (offset < 0) {
            offset += this.buffer.length;
        }
        return offset;
    }
}

