/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.test.LookupProvider;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

final class Lookups {
    private static final Map<String, MethodHandles.Lookup> MODULE_LOOKUP_MAP = ServiceLoader.load(LookupProvider.class).stream().collect(Collectors.toMap(p -> p.type().getModule().getName(), p -> ((LookupProvider)p.get()).provideLookup()));
    private static final MethodHandles.Lookup DEFAULT_LOOKUP = MethodHandles.publicLookup();

    Lookups() {
    }

    static MethodHandles.Lookup getLookup(Class<?> type) {
        return MODULE_LOOKUP_MAP.getOrDefault(type.getModule().getName(), DEFAULT_LOOKUP);
    }

    static VarHandle getVarhandle(Field field) {
        try {
            Class<?> declaringClass = field.getDeclaringClass();
            MethodHandles.Lookup lookup = Lookups.getLookup(declaringClass);
            lookup = lookup.hasPrivateAccess() ? MethodHandles.privateLookupIn(declaringClass, Lookups.getLookup(declaringClass)) : lookup;
            return lookup.unreflectVarHandle(field);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't access field " + String.valueOf(field), e);
        }
    }

    static Class<?> getClassFromType(Type generic) {
        if (generic instanceof Class) {
            return (Class)generic;
        }
        if (generic instanceof ParameterizedType) {
            Type actual = ((ParameterizedType)generic).getActualTypeArguments()[0];
            if (actual instanceof Class) {
                return (Class)actual;
            }
            if (actual instanceof ParameterizedType) {
                return (Class)((ParameterizedType)actual).getRawType();
            }
        }
        return Object.class;
    }
}

