/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.GlobalTestBeans;
import io.avaje.inject.test.InjectTest;
import io.avaje.inject.test.MetaReader;
import io.avaje.inject.test.Plugin;
import io.avaje.inject.test.PluginMgr;
import io.avaje.inject.test.TestBeans;
import java.util.Optional;

final class MetaInfo {
    private final MetaReader reader;

    MetaInfo(Class<?> testClass, Plugin plugin) {
        this.reader = new MetaReader(testClass, plugin);
    }

    boolean hasStaticInjection() {
        return this.reader.hasClassInjection();
    }

    boolean hasInstanceInjection() {
        return this.reader.hasInstanceInjection();
    }

    TestBeans buildForClass(GlobalTestBeans.Beans globalTestScope) {
        return this.buildSet(globalTestScope, null);
    }

    TestBeans buildForInstance(GlobalTestBeans.Beans globalTestScope, Object testInstance) {
        return this.buildSet(globalTestScope, testInstance);
    }

    private TestBeans buildSet(GlobalTestBeans.Beans parent, Object testInstance) {
        TestBeans testBeans = this.buildTestBeans(parent, testInstance);
        return this.reader.setFromScope(testBeans, testInstance);
    }

    private TestBeans buildTestBeans(GlobalTestBeans.Beans parent, Object testInstance) {
        String[] profiles = Optional.ofNullable(testInstance).map(Object::getClass).map(c -> c.getAnnotation(InjectTest.class)).map(InjectTest::profiles).orElse(new String[0]);
        if (profiles.length > 0 || this.reader.hasMocksOrSpies(testInstance)) {
            BeanScopeBuilder builder = BeanScope.builder();
            if (parent != null) {
                builder.parent(parent.baseBeans(), false);
                if (profiles.length > 0) {
                    builder.profiles(profiles);
                }
            }
            this.reader.build(builder, testInstance);
            BeanScope newBeanScope = builder.build();
            Plugin.Scope newPlugin = PluginMgr.scope(newBeanScope);
            return new TestBeans(newBeanScope, newPlugin);
        }
        return new TestBeans(parent);
    }
}

