/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.InMemoryBufferingS3OutputStream;
import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStream;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.unit.DataSize;
import software.amazon.awssdk.services.s3.S3Client;

public class InMemoryBufferingS3OutputStreamProvider
implements S3OutputStreamProvider {
    private final S3Client s3Client;
    @Nullable
    private final S3ObjectContentTypeResolver contentTypeResolver;
    @Nullable
    private final DataSize bufferSize;

    public InMemoryBufferingS3OutputStreamProvider(S3Client s3Client, @Nullable S3ObjectContentTypeResolver contentTypeResolver) {
        this(s3Client, contentTypeResolver, null);
    }

    public InMemoryBufferingS3OutputStreamProvider(S3Client s3Client, @Nullable S3ObjectContentTypeResolver contentTypeResolver, @Nullable DataSize bufferSize) {
        this.s3Client = s3Client;
        this.contentTypeResolver = contentTypeResolver;
        this.bufferSize = bufferSize;
    }

    @Override
    public S3OutputStream create(String bucket, String key, @Nullable ObjectMetadata metadata) throws IOException {
        return new InMemoryBufferingS3OutputStream(new Location(bucket, key, null), this.s3Client, metadata, this.contentTypeResolver, this.bufferSize);
    }
}

