/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectConverter;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.sync.RequestBody;

public class Jackson2JsonS3ObjectConverter
implements S3ObjectConverter {
    private final ObjectMapper objectMapper;

    public Jackson2JsonS3ObjectConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper is required");
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> RequestBody write(T object) {
        Assert.notNull(object, (String)"object is required");
        try {
            return RequestBody.fromBytes((byte[])this.objectMapper.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw new S3Exception("Failed to serialize object to JSON", e);
        }
    }

    @Override
    public <T> T read(InputStream is, Class<T> clazz) {
        Assert.notNull((Object)is, (String)"InputStream is required");
        Assert.notNull(clazz, (String)"Clazz is required");
        try {
            return (T)this.objectMapper.readValue(is, clazz);
        }
        catch (IOException e) {
            throw new S3Exception("Failed to deserialize object from JSON", e);
        }
    }

    @Override
    public String contentType() {
        return "application/json";
    }
}

