/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.autoconfigure;

import io.beanmapper.BeanMapper;
import io.beanmapper.autoconfigure.ApplicationScanner;
import io.beanmapper.autoconfigure.BeanMapFromClass;
import io.beanmapper.autoconfigure.BeanMapToClass;
import io.beanmapper.autoconfigure.BeanMapperBuilderCustomizer;
import io.beanmapper.autoconfigure.BeanMapperProperties;
import io.beanmapper.config.AfterClearFlusher;
import io.beanmapper.config.BeanMapperBuilder;
import io.beanmapper.core.collections.CollectionHandler;
import io.beanmapper.core.converter.BeanConverter;
import io.beanmapper.core.unproxy.BeanUnproxy;
import io.beanmapper.spring.converter.IdToEntityBeanConverter;
import io.beanmapper.spring.flusher.JpaAfterClearFlusher;
import io.beanmapper.spring.unproxy.HibernateAwareBeanUnproxy;
import io.beanmapper.spring.web.MergedFormMethodArgumentResolver;
import io.beanmapper.spring.web.converter.StructuredJsonMessageConverter;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={BeanMapperProperties.class})
public class BeanMapperAutoConfig {
    private final Logger log = LoggerFactory.getLogger(BeanMapperAutoConfig.class);
    @Autowired
    private BeanMapperProperties props;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private BeanMapperBuilderCustomizer builderCustomizer;
    @Autowired(required=false)
    private EntityManager entityManager;
    private ApplicationScanner collectionHandlerAppScanner;
    private ApplicationScanner beanConverterAppScanner;

    @PostConstruct
    private void initApplicationScanner() {
        this.collectionHandlerAppScanner = new ApplicationScanner(this.applicationContext);
        this.beanConverterAppScanner = new ApplicationScanner(this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanMapper.class})
    @ConditionalOnClass(value={EntityInformation.class})
    public BeanMapper beanMapper() {
        String packagePrefix = this.determinePackagePrefix();
        BeanMapperBuilder builder = new BeanMapperBuilder().setApplyStrictMappingConvention(this.props.isApplyStrictMappingConvention()).setStrictSourceSuffix(this.props.getStrictSourceSuffix()).setStrictTargetSuffix(this.props.getStrictTargetSuffix()).addPackagePrefix(packagePrefix).addConverter((BeanConverter)new IdToEntityBeanConverter(this.applicationContext));
        this.addCollectionHandlers(builder, packagePrefix);
        this.addCustomConverters(builder, packagePrefix);
        this.addCustomBeanPairs(builder);
        this.addAfterClearFlusher(builder);
        this.setUnproxy(builder);
        this.customize(builder);
        return builder.build();
    }

    private void addAfterClearFlusher(BeanMapperBuilder builder) {
        if (this.entityManager == null) {
            return;
        }
        builder.addAfterClearFlusher((AfterClearFlusher)new JpaAfterClearFlusher(this.entityManager));
    }

    private String determinePackagePrefix() {
        String packagePrefix = this.props.getPackagePrefix();
        if (packagePrefix == null) {
            this.log.info("No beanmapper.package-prefix found in environment properties, defaulting to SpringBootApplication annotated class package.");
            packagePrefix = this.beanConverterAppScanner.findApplicationPackage().orElseThrow(() -> new RuntimeException("Application package not found, define beanmapper.package-prefix property in your environment!"));
        }
        this.log.info("Set beanmapper packagePrefix [{}]", (Object)packagePrefix);
        return packagePrefix;
    }

    private void addCustomBeanPairs(BeanMapperBuilder builder) {
        this.beanConverterAppScanner.findBeanPairInstructions().forEach(cls -> {
            BeanMapToClass beanMapToClass = cls.getDeclaredAnnotation(BeanMapToClass.class);
            BeanMapFromClass beanMapFromClass = cls.getDeclaredAnnotation(BeanMapFromClass.class);
            if (beanMapToClass != null) {
                builder.addBeanPairWithStrictSource(cls, beanMapToClass.target());
            } else if (beanMapFromClass != null) {
                builder.addBeanPairWithStrictTarget(beanMapFromClass.source(), cls);
            }
        });
    }

    private void addCollectionHandlers(BeanMapperBuilder builder, String basePackage) {
        this.collectionHandlerAppScanner.findCollectionHandlerClasses(basePackage).forEach(cls -> {
            CollectionHandler collectionHandler = (CollectionHandler)this.instantiateClassAppContextOptional((Class)cls, "collection handler");
            if (collectionHandler != null) {
                builder.addCollectionHandler(collectionHandler);
            }
        });
    }

    private void addCustomConverters(BeanMapperBuilder builder, String basePackage) {
        this.beanConverterAppScanner.findBeanConverterClasses(basePackage).forEach(cls -> {
            BeanConverter converter = (BeanConverter)this.instantiateClassAppContextOptional((Class)cls, "bean converter");
            if (converter != null) {
                builder.addConverter(converter);
            }
        });
    }

    private <T> T instantiateClassAppContextOptional(Class<T> cls, String label) {
        this.log.info("Found {} candidate class [{}], now trying to instantiate...", (Object)label, cls);
        try {
            Object created = BeanUtils.instantiate(cls);
            this.log.info("Added [{}] [{}] to bean mapper.", (Object)label, cls);
            return (T)created;
        }
        catch (BeanInstantiationException e) {
            this.log.debug("Cannot instantiate bean of class [{}] with no-arg constructor, now trying appContext constructor...", cls);
            try {
                Object created = BeanUtils.instantiateClass(cls.getConstructor(ApplicationContext.class), (Object[])new Object[]{this.applicationContext});
                this.log.info("Added [{}] [{}] to bean mapper.", (Object)label, cls);
                return (T)created;
            }
            catch (NoSuchMethodException | SecurityException | BeanInstantiationException ex) {
                this.log.warn("Cannot instantiate bean of class [{}] with applicationContext constructor, this [{}] will be skipped!", cls, (Object)label);
                return null;
            }
        }
    }

    private void setUnproxy(BeanMapperBuilder builder) {
        if (this.props.isUseHibernateUnproxy()) {
            builder.setBeanUnproxy((BeanUnproxy)new HibernateAwareBeanUnproxy());
            this.log.info("Set HibernateAwareUnproxy as bean unproxy mechanism.");
        } else {
            this.log.info("use-hibernate-unproxy set to false, keeping default unproxy mechanism.");
        }
    }

    private void customize(BeanMapperBuilder builder) {
        if (this.builderCustomizer != null) {
            this.log.info("Customizing BeanMapperBuilder...");
            this.builderCustomizer.customize(builder);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={EntityInformation.class})
    static class MergedFormConfig
    extends WebMvcConfigurerAdapter {
        private final Logger log = LoggerFactory.getLogger(MergedFormConfig.class);
        @Autowired(required=false)
        private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;
        @Autowired
        private BeanMapper beanMapper;
        @Autowired
        private ApplicationContext applicationContext;

        MergedFormConfig() {
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            if (this.mappingJackson2HttpMessageConverter != null) {
                this.log.info("Adding MergedFormArgumentResolver to MVC application.");
                argumentResolvers.add((HandlerMethodArgumentResolver)new MergedFormMethodArgumentResolver(Collections.singletonList(new StructuredJsonMessageConverter(this.mappingJackson2HttpMessageConverter)), this.beanMapper, this.applicationContext));
            } else {
                this.log.warn("No MergedFormArgumentResolver added to MVC application because no MappingJackson2HttpMessageConverter bean found!");
            }
        }
    }
}

