/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j;

import io.buji.pac4j.ClientToken;
import io.buji.pac4j.NoAuthenticationException;
import io.buji.pac4j.ShiroWebContext;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFilter
extends AuthenticatingFilter {
    private static Logger log = LoggerFactory.getLogger(ClientFilter.class);
    private String failureUrl;
    private Clients clients;
    private boolean redirectAfterSuccessfulAuthentication = true;

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        ShiroWebContext context = new ShiroWebContext(WebUtils.toHttp((ServletRequest)request), WebUtils.toHttp((ServletResponse)response));
        Client client = this.clients.findClient((WebContext)context);
        log.debug("client : {}", (Object)client);
        Credentials credentials = client.getCredentials((WebContext)context);
        log.debug("credentials : {}", (Object)credentials);
        return new ClientToken(client.getName(), credentials);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token;
        try {
            token = this.createToken(request, response);
        }
        catch (RequiresHttpAction e) {
            log.debug("requires HTTP action : {}", (Throwable)e);
            return false;
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (NoAuthenticationException e) {
            return this.onLoginSuccess(token, null, request, response);
        }
        catch (AuthenticationException e) {
            return this.onLoginFailure(token, e, request, response);
        }
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return false;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        log.info("Login success");
        if (!this.redirectAfterSuccessfulAuthentication) {
            return true;
        }
        this.issueSuccessRedirect(request, response);
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        log.warn("Login failure", (Throwable)ae);
        Subject subject = this.getSubject(request, response);
        if (subject.isAuthenticated()) {
            try {
                this.issueSuccessRedirect(request, response);
            }
            catch (Exception e) {
                log.error("Cannot redirect to the default success url", (Throwable)e);
            }
        } else {
            try {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.failureUrl);
            }
            catch (IOException e) {
                log.error("Cannot redirect to failure url : {}", (Object)this.failureUrl, (Object)e);
            }
        }
        return false;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public Clients getClients() {
        return this.clients;
    }

    public void setClients(Clients clients) throws TechnicalException {
        this.clients = clients;
        this.clients.init();
    }

    public boolean getRedirectAfterSuccessfulAuthentication() {
        return this.redirectAfterSuccessfulAuthentication;
    }

    public void setRedirectAfterSuccessfulAuthentication(boolean casPassThrough) {
        this.redirectAfterSuccessfulAuthentication = casPassThrough;
    }
}

