/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j;

import io.buji.pac4j.ClientToken;
import io.buji.pac4j.NoAuthenticationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRealm
extends AuthorizingRealm {
    private static Logger log = LoggerFactory.getLogger(ClientRealm.class);
    private Clients clients;
    private String defaultRoles;
    private String defaultPermissions;

    public ClientRealm() {
        this.setAuthenticationTokenClass(ClientToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        try {
            return this.internalGetAuthenticationInfo(authenticationToken);
        }
        catch (TechnicalException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    protected AuthenticationInfo internalGetAuthenticationInfo(AuthenticationToken authenticationToken) {
        ClientToken clientToken = (ClientToken)authenticationToken;
        log.debug("clientToken : {}", (Object)clientToken);
        if (clientToken == null) {
            return null;
        }
        Credentials credentials = (Credentials)clientToken.getCredentials();
        log.debug("credentials : {}", (Object)credentials);
        Client client = this.clients.findClient(clientToken.getClientName());
        log.debug("client : {}", (Object)client);
        CommonProfile profile = (CommonProfile)client.getUserProfile(credentials, null);
        log.debug("profile : {}", (Object)profile);
        if (profile == null) {
            String message = "No profile retrieved from authentication using client : " + client + " and credentials : " + credentials;
            log.info(message);
            throw new NoAuthenticationException(message);
        }
        String userId = profile.getTypedId();
        clientToken.setUserId(userId);
        clientToken.setRememberMe(profile.isRemembered());
        List principals = CollectionUtils.asList((Object[])new Serializable[]{userId, profile});
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)credentials);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        HashSet<String> roles = new HashSet<String>(this.split(this.defaultRoles));
        HashSet<String> permissions = new HashSet<String>(this.split(this.defaultPermissions));
        Collection profiles = principals.byType(CommonProfile.class);
        if (profiles != null) {
            for (CommonProfile profile : profiles) {
                if (profile == null) continue;
                roles.addAll(profile.getRoles());
                permissions.addAll(profile.getPermissions());
            }
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        simpleAuthorizationInfo.addRoles(roles);
        simpleAuthorizationInfo.addStringPermissions(permissions);
        return simpleAuthorizationInfo;
    }

    protected List<String> split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String[] elements = StringUtils.split((String)s, (char)',');
        if (elements != null && elements.length > 0) {
            for (String element : elements) {
                if (!StringUtils.hasText((String)element)) continue;
                list.add(element.trim());
            }
        }
        return list;
    }

    public Clients getClients() {
        return this.clients;
    }

    public void setClients(Clients clients) throws TechnicalException {
        this.clients = clients;
        this.clients.init();
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public void setDefaultPermissions(String defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }
}

