/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.util.time;

import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Interval
implements TemporalAmount {
    private static final Duration ACCURATE_DURATION_UPPER_BOUND = Duration.ofDays(1L);
    private final List<TemporalUnit> units;
    private final Period period;
    private final Duration duration;
    private final Optional<ZonedDateTime> start;

    public Interval(Period period, Duration duration) {
        this(Optional.empty(), period, duration);
    }

    public Interval(Optional<ZonedDateTime> start, Period period, Duration duration) {
        this.period = period;
        this.duration = duration;
        this.start = start;
        this.units = new ArrayList<TemporalUnit>();
        this.units.addAll(period.getUnits());
        this.units.addAll(duration.getUnits());
    }

    public Interval(Duration duration) {
        this(Period.ZERO, duration);
    }

    public Interval(Period period) {
        this(period, Duration.ZERO);
    }

    public Period getPeriod() {
        return this.period;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Optional<ZonedDateTime> getStart() {
        return this.start;
    }

    public long toEpochMilli(long fromEpochMilli) {
        long epochMilli = this.start.map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli).orElse(fromEpochMilli);
        if (epochMilli <= fromEpochMilli) {
            if (!this.isCalendarBased()) {
                return fromEpochMilli + this.getDuration().toMillis();
            }
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromEpochMilli), ZoneId.systemDefault()).plus(this).toInstant().toEpochMilli();
        }
        return epochMilli;
    }

    public Interval withStart(Instant start) {
        ZoneId zoneId = this.getStart().map(ZonedDateTime::getZone).orElse(ZoneId.systemDefault());
        return new Interval(Optional.of(ZonedDateTime.ofInstant(start, zoneId).plus(this)), this.getPeriod(), this.getDuration());
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.SECONDS || unit == ChronoUnit.NANOS) {
            return this.duration.get(unit);
        }
        return this.period.get(unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.units;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.period).plus(this.duration);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.period).minus(this.duration);
    }

    public int hashCode() {
        return Objects.hash(this.getPeriod(), this.getDuration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)o;
        return Objects.equals(this.getPeriod(), interval.getPeriod()) && Objects.equals(this.getDuration(), interval.getDuration()) && Objects.equals(this.getStart(), interval.getStart());
    }

    public String toString() {
        if (this.period.isZero()) {
            return this.duration.toString();
        }
        if (this.duration.isZero()) {
            return this.period.toString();
        }
        return this.period.toString() + this.duration.toString().substring(1);
    }

    private boolean isCalendarBased() {
        return !this.getPeriod().isZero() || this.getDuration().compareTo(ACCURATE_DURATION_UPPER_BOUND) >= 0;
    }

    public static Interval parse(String text) {
        String intervalExp;
        String sign = "";
        int startOffset = 0;
        int index = text.lastIndexOf("/");
        Optional<ZonedDateTime> start = Optional.empty();
        if (index > 0) {
            start = Optional.ofNullable(ZonedDateTime.parse(text.substring(0, index)));
        }
        if ((intervalExp = text.substring(index + 1)).startsWith("-")) {
            startOffset = 1;
            sign = "-";
        } else if (intervalExp.startsWith("+")) {
            startOffset = 1;
        }
        int durationOffset = intervalExp.indexOf(84);
        if (durationOffset == -1) {
            return new Interval(start, Period.parse(intervalExp), Duration.ZERO);
        }
        if (durationOffset == startOffset + 1) {
            return new Interval(start, Period.ZERO, Duration.parse(intervalExp));
        }
        return new Interval(start, Period.parse(intervalExp.substring(0, durationOffset)), Duration.parse(sign + "P" + intervalExp.substring(durationOffset)));
    }
}

