/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.DefaultRequestOptions;
import coil.ImageLoader;
import coil.RealImageLoader;
import coil.util.CoilUtils;
import coil.util.ContextsKt;
import coil.util.ExtensionsKt;
import coil.util.Utils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0018\u001a\u00020\u00002\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001dH\u0086\bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010#\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020 J\u0014\u0010'\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020(0\u0017J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010)\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcoil/ImageLoaderBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "availableMemoryPercentage", "", "bitmapPoolPercentage", "callFactory", "Lokhttp3/Call$Factory;", "defaults", "Lcoil/DefaultRequestOptions;", "registry", "Lcoil/ComponentRegistry;", "allowHardware", "enable", "", "allowRgb565", "multiplier", "build", "Lcoil/ImageLoader;", "buildDefaultCallFactory", "initializer", "Lkotlin/Function0;", "componentRegistry", "builder", "Lkotlin/Function1;", "Lcoil/ComponentRegistry$Builder;", "", "Lkotlin/ExtensionFunctionType;", "crossfade", "durationMillis", "", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "error", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "okHttpClient", "Lokhttp3/OkHttpClient;", "placeholder", "coil-base_release"})
public final class ImageLoaderBuilder {
    private Call.Factory callFactory;
    private ComponentRegistry registry;
    private double availableMemoryPercentage;
    private double bitmapPoolPercentage;
    private DefaultRequestOptions defaults;
    private final Context context;

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        return this.callFactory((Call.Factory)okHttpClient);
    }

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull Function0<? extends OkHttpClient> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        return this.callFactory(initializer);
    }

    @NotNull
    public final ImageLoaderBuilder callFactory(@NotNull Call.Factory callFactory) {
        Intrinsics.checkParameterIsNotNull((Object)callFactory, (String)"callFactory");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.callFactory = callFactory;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder callFactory(@NotNull Function0<? extends Call.Factory> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.callFactory = ExtensionsKt.lazyCallFactory(initializer);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder componentRegistry(@NotNull Function1<? super ComponentRegistry.Builder, Unit> builder) {
        int $i$f$componentRegistry = 0;
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        ComponentRegistry.Companion companion = ComponentRegistry.Companion;
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean $i$f$invoke = false;
        ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
        boolean bl = false;
        boolean bl2 = false;
        builder.invoke((Object)builder2);
        ComponentRegistry componentRegistry = builder2.build();
        return imageLoaderBuilder.componentRegistry(componentRegistry);
    }

    @NotNull
    public final ImageLoaderBuilder componentRegistry(@NotNull ComponentRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.registry = registry;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.availableMemoryPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder bitmapPoolPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.bitmapPoolPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, dispatcher, false, false, 0, null, null, 62, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder allowHardware(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, enable, false, 0, null, null, 61, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder allowRgb565(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, enable, 0, null, null, 59, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, enable ? 100 : 0, null, null, 55, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(int durationMillis) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        boolean bl4 = durationMillis >= 0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Duration must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, durationMillis, null, null, 55, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, 0, ContextsKt.getDrawableCompat($this$apply.context, drawableResId), null, 47, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@Nullable Drawable drawable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, 0, drawable, null, 47, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, 0, null, ContextsKt.getDrawableCompat($this$apply.context, drawableResId), 31, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@Nullable Drawable drawable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, false, false, 0, null, drawable, 31, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoader build() {
        ComponentRegistry componentRegistry;
        long availableMemorySize = Utils.INSTANCE.calculateAvailableMemorySize(this.context, this.availableMemoryPercentage);
        long bitmapPoolSize = (long)(this.bitmapPoolPercentage * (double)availableMemorySize);
        int memoryCacheSize = (int)(availableMemorySize - bitmapPoolSize);
        Context context = this.context;
        DefaultRequestOptions defaultRequestOptions = this.defaults;
        long l = bitmapPoolSize;
        int n = memoryCacheSize;
        Call.Factory factory = this.callFactory;
        if (factory == null) {
            factory = this.buildDefaultCallFactory();
        }
        if ((componentRegistry = this.registry) == null) {
            ComponentRegistry.Companion companion = ComponentRegistry.Companion;
            Call.Factory factory2 = factory;
            int n2 = n;
            long l2 = l;
            DefaultRequestOptions defaultRequestOptions2 = defaultRequestOptions;
            Context context2 = context;
            boolean $i$f$invoke = false;
            ComponentRegistry.Builder builder = new ComponentRegistry.Builder();
            boolean bl = false;
            boolean bl2 = false;
            ComponentRegistry.Builder $receiver = builder;
            ComponentRegistry componentRegistry2 = builder.build();
            context = context2;
            defaultRequestOptions = defaultRequestOptions2;
            l = l2;
            n = n2;
            factory = factory2;
            componentRegistry = componentRegistry2;
        }
        ComponentRegistry componentRegistry3 = componentRegistry;
        Call.Factory factory3 = factory;
        int n3 = n;
        long l3 = l;
        DefaultRequestOptions defaultRequestOptions3 = defaultRequestOptions;
        Context context3 = context;
        return new RealImageLoader(context3, defaultRequestOptions3, l3, n3, factory3, componentRegistry3);
    }

    private final Call.Factory buildDefaultCallFactory() {
        return ExtensionsKt.lazyCallFactory((Function0<? extends Call.Factory>)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ ImageLoaderBuilder this$0;

            public final OkHttpClient invoke() {
                OkHttpClient okHttpClient = new OkHttpClient.Builder().cache(CoilUtils.createDefaultCache(ImageLoaderBuilder.access$getContext$p(this.this$0))).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026xt))\n            .build()");
                return okHttpClient;
            }
            {
                this.this$0 = imageLoaderBuilder;
                super(0);
            }
        }));
    }

    public ImageLoaderBuilder(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(this.context);
        this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
        this.defaults = new DefaultRequestOptions(null, false, false, 0, null, null, 63, null);
    }

    public static final /* synthetic */ Context access$getContext$p(ImageLoaderBuilder $this) {
        return $this.context;
    }
}

