/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmappool;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Px;
import androidx.collection.ArraySet;
import coil.bitmappool.BitmapPool;
import coil.bitmappool.strategy.BitmapPoolStrategy;
import coil.util.CoilLogger;
import coil.util.ExtensionsKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J$\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J$\u0010\u001c\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J&\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J&\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0019H\u0016J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcoil/bitmappool/RealBitmapPool;", "Lcoil/bitmappool/BitmapPool;", "maxSize", "", "allowedConfigs", "", "Landroid/graphics/Bitmap$Config;", "strategy", "Lcoil/bitmappool/strategy/BitmapPoolStrategy;", "(JLjava/util/Set;Lcoil/bitmappool/strategy/BitmapPoolStrategy;)V", "currentSize", "evictions", "", "hits", "misses", "puts", "assertNotHardwareConfig", "", "config", "clear", "clearMemory", "computeUnchecked", "", "dump", "get", "Landroid/graphics/Bitmap;", "width", "height", "getDirty", "getDirtyOrNull", "getOrNull", "normalize", "bitmap", "put", "trimMemory", "level", "trimToSize", "size", "Companion", "coil-base_release"})
public final class RealBitmapPool
implements BitmapPool {
    private long currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;
    private final long maxSize;
    private final Set<Bitmap.Config> allowedConfigs;
    private final BitmapPoolStrategy strategy;
    private static final String TAG = "RealBitmapPool";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void put(@NotNull Bitmap bitmap) {
        int priority$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        boolean bl = !bitmap.isRecycled();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot pool recycled bitmap!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int size = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        if (!bitmap.isMutable() || (long)size > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            String string = TAG;
            priority$iv = 2;
            boolean $i$f$log = false;
            if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
                void tag$iv22;
                void var8_11 = tag$iv22;
                int n = priority$iv;
                boolean bl5 = false;
                String string2 = "Rejected bitmap from pool: bitmap: " + this.strategy.logBitmap(bitmap) + ", " + "is mutable: " + bitmap.isMutable() + ", " + "is greater than max size: " + ((long)size > this.maxSize) + "is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig());
                Log.println((int)n, (String)var8_11, (String)string2);
            }
            bitmap.recycle();
            return;
        }
        this.strategy.put(bitmap);
        int tag$iv22 = this.puts;
        this.puts = tag$iv22 + 1;
        this.currentSize += (long)size;
        String tag$iv22 = TAG;
        priority$iv = 2;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            String string = tag$iv22;
            int n = priority$iv;
            boolean bl6 = false;
            String string3 = "Put bitmap in pool=" + this.strategy.logBitmap(bitmap);
            Log.println((int)n, (String)string, (String)string3);
        }
        this.dump();
        this.trimToSize(this.maxSize);
    }

    @Override
    @NotNull
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap result = this.getOrNull(width, height, config);
        Bitmap bitmap = result;
        if (bitmap == null) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(width, height, config)");
        }
        return bitmap;
    }

    @Override
    @Nullable
    public Bitmap getOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Bitmap result;
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Bitmap bitmap = result = this.getDirtyOrNull(width, height, config);
            if (bitmap == null) break block0;
            bitmap.eraseColor(0);
        }
        return result;
    }

    @Override
    @NotNull
    public Bitmap getDirty(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap result = this.getDirtyOrNull(width, height, config);
        Bitmap bitmap = result;
        if (bitmap == null) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(width, height, config)");
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public synchronized Bitmap getDirtyOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        int tag$iv2;
        String string;
        int n;
        String string2;
        boolean $i$f$log;
        int priority$iv;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.assertNotHardwareConfig(config);
        Bitmap result = this.strategy.get(width, height, config);
        if (result == null) {
            String string3 = TAG;
            priority$iv = 3;
            $i$f$log = false;
            if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
                void tag$iv2;
                string2 = tag$iv2;
                n = priority$iv;
                boolean bl = false;
                string = "Missing bitmap=" + this.strategy.logBitmap(width, height, config);
                Log.println((int)n, (String)string2, (String)string);
            }
            tag$iv2 = this.misses;
            this.misses = tag$iv2 + 1;
        } else {
            tag$iv2 = this.hits;
            this.hits = tag$iv2 + 1;
            this.currentSize -= (long)ExtensionsKt.getAllocationByteCountCompat(result);
            this.normalize(result);
        }
        String tag$iv2 = TAG;
        priority$iv = 2;
        $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            string2 = tag$iv2;
            n = priority$iv;
            boolean bl = false;
            string = "Get bitmap=" + this.strategy.logBitmap(width, height, config);
            Log.println((int)n, (String)string2, (String)string);
        }
        this.dump();
        return result;
    }

    @Override
    public void clear() {
        this.clearMemory();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearMemory() {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var6_4 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "clearMemory";
            Log.println((int)n, (String)var6_4, (String)string2);
        }
        this.trimToSize(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void trimMemory(int level) {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var7_6 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "trimMemory, level=" + level;
            Log.println((int)n, (String)var7_6, (String)string2);
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            int n = level;
            if (10 <= n && 20 > n) {
                this.trimToSize(this.currentSize / (long)2);
            }
        }
    }

    private final void normalize(Bitmap bitmap) {
        bitmap.setDensity(0);
        bitmap.setHasAlpha(true);
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap.setPremultiplied(true);
        }
    }

    private final synchronized void trimToSize(long size) {
        while (this.currentSize > size) {
            String string;
            int n;
            String string2;
            String tag$iv22;
            boolean $i$f$log;
            int priority$iv;
            Bitmap removed = this.strategy.removeLast();
            if (removed == null) {
                String string3 = TAG;
                priority$iv = 5;
                $i$f$log = false;
                if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
                    string2 = tag$iv22;
                    n = priority$iv;
                    boolean bl = false;
                    string = "Size mismatch, resetting.\n" + this.computeUnchecked();
                    Log.println((int)n, (String)string2, (String)string);
                }
                this.currentSize = 0L;
                return;
            }
            this.currentSize -= (long)ExtensionsKt.getAllocationByteCountCompat(removed);
            int tag$iv22 = this.evictions;
            this.evictions = tag$iv22 + 1;
            tag$iv22 = TAG;
            priority$iv = 3;
            $i$f$log = false;
            if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
                string2 = tag$iv22;
                n = priority$iv;
                boolean bl = false;
                string = "Evicting bitmap=" + this.strategy.logBitmap(removed);
                Log.println((int)n, (String)string2, (String)string);
            }
            this.dump();
            removed.recycle();
        }
    }

    private final void assertNotHardwareConfig(Bitmap.Config config) {
        boolean bl = Build.VERSION.SDK_INT < 26 || config != Bitmap.Config.HARDWARE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot create a mutable hardware Bitmap.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dump() {
        String string = TAG;
        int priority$iv = 2;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var6_4 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = this.computeUnchecked();
            Log.println((int)n, (String)var6_4, (String)string2);
        }
    }

    private final String computeUnchecked() {
        return "Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", " + "currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + ", strategy=" + this.strategy;
    }

    public RealBitmapPool(long maxSize, @NotNull Set<? extends Bitmap.Config> allowedConfigs, @NotNull BitmapPoolStrategy strategy) {
        Intrinsics.checkParameterIsNotNull(allowedConfigs, (String)"allowedConfigs");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        this.maxSize = maxSize;
        this.allowedConfigs = allowedConfigs;
        this.strategy = strategy;
    }

    public /* synthetic */ RealBitmapPool(long l, Set set, BitmapPoolStrategy bitmapPoolStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = RealBitmapPool.Companion.getDefaultAllowedConfigs();
        }
        if ((n & 4) != 0) {
            bitmapPoolStrategy = BitmapPoolStrategy.Companion.invoke();
        }
        this(l, set, bitmapPoolStrategy);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/bitmappool/RealBitmapPool$Companion;", "", "()V", "TAG", "", "getDefaultAllowedConfigs", "", "Landroid/graphics/Bitmap$Config;", "coil-base_release"})
    public static final class Companion {
        private final Set<Bitmap.Config> getDefaultAllowedConfigs() {
            boolean $i$f$arraySetOf = false;
            boolean $i$f$arraySetOf2 = false;
            ArraySet arraySet = new ArraySet();
            boolean bl = false;
            boolean bl2 = false;
            Set $this$arraySetOf = (Set)arraySet;
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)$this$arraySetOf, (Object[])Bitmap.Config.values());
            if (Build.VERSION.SDK_INT >= 26) {
                $this$arraySetOf.remove(Bitmap.Config.HARDWARE);
            }
            return (Set)arraySet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

