/*
 * Decompiled with CFR 0.152.
 */
package coil.collection;

import coil.collection.ArrayUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/collection/SparseIntArraySet;", "", "initialCapacity", "", "(I)V", "elements", "", "size", "add", "", "element", "clear", "", "contains", "elementAt", "index", "indexOfElement", "key", "remove", "removeAt", "coil-base_release"})
public final class SparseIntArraySet {
    private int[] elements;
    private int size;

    public final boolean add(int element) {
        boolean absent;
        int i = ArraysKt.binarySearch$default((int[])this.elements, (int)element, (int)0, (int)this.size, (int)2, null);
        boolean bl = absent = i < 0;
        if (absent) {
            this.elements = ArrayUtils.INSTANCE.insert(this.elements, this.size, ~i, element);
            int n = this.size;
            this.size = n + 1;
        }
        return absent;
    }

    public final boolean remove(int element) {
        boolean present;
        int i = ArraysKt.binarySearch$default((int[])this.elements, (int)element, (int)0, (int)this.size, (int)2, null);
        boolean bl = present = i >= 0;
        if (present) {
            this.removeAt(i);
        }
        return present;
    }

    public final boolean contains(int element) {
        return ArraysKt.binarySearch$default((int[])this.elements, (int)element, (int)0, (int)this.size, (int)2, null) >= 0;
    }

    public final void removeAt(int index) {
        System.arraycopy(this.elements, index + 1, this.elements, index, this.size - (index + 1));
        int n = this.size;
        this.size = n + -1;
    }

    public final int size() {
        return this.size;
    }

    public final int elementAt(int index) {
        return this.elements[index];
    }

    public final int indexOfElement(int key) {
        return ArraysKt.binarySearch$default((int[])this.elements, (int)key, (int)0, (int)this.size, (int)2, null);
    }

    public final void clear() {
        this.size = 0;
    }

    public SparseIntArraySet(int initialCapacity) {
        this.elements = new int[initialCapacity];
    }

    public /* synthetic */ SparseIntArraySet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public SparseIntArraySet() {
        this(0, 1, null);
    }
}

