/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import androidx.annotation.WorkerThread;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import coil.bitmappool.BitmapPool;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Size;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcoil/decode/DrawableDecoderService;", "", "context", "Landroid/content/Context;", "bitmapPool", "Lcoil/bitmappool/BitmapPool;", "(Landroid/content/Context;Lcoil/bitmappool/BitmapPool;)V", "convert", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "size", "Lcoil/size/Size;", "config", "Landroid/graphics/Bitmap$Config;", "convertIfNecessary", "shouldConvertToBitmap", "", "coil-base_release"})
public final class DrawableDecoderService {
    private final Context context;
    private final BitmapPool bitmapPool;

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Drawable convertIfNecessary(@NotNull Drawable drawable, @NotNull Size size, @NotNull Bitmap.Config config) {
        Drawable drawable2;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        if (this.shouldConvertToBitmap(drawable)) {
            void $this$toDrawable$iv$iv;
            void $this$toDrawable$iv;
            Bitmap bitmap = this.convert(drawable, size, config);
            Context context$iv = this.context;
            boolean $i$f$toDrawable = false;
            void var7_7 = $this$toDrawable$iv;
            Resources resources = context$iv.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            Resources resources$iv$iv = resources;
            boolean $i$f$toDrawable2 = false;
            drawable2 = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
        } else {
            drawable2 = drawable;
        }
        return drawable2;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Bitmap convert(@NotNull Drawable drawable, @NotNull Size size, @NotNull Bitmap.Config config) {
        void oldRight;
        void oldTop;
        void oldLeft;
        void width;
        Rect rect;
        PixelSize pixelSize;
        Size size2;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap.Config safeConfig = ExtensionsKt.normalize(config);
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            if (ExtensionsKt.normalize(bitmap2.getConfig()) == safeConfig) {
                return bitmap;
            }
        }
        if ((size2 = size) instanceof OriginalSize) {
            pixelSize = new PixelSize(ExtensionsKt.getWidth(drawable), ExtensionsKt.getHeight(drawable));
        } else if (size2 instanceof PixelSize) {
            pixelSize = (PixelSize)size;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PixelSize pixelSize2 = pixelSize;
        int bitmap = pixelSize2.component1();
        int height = pixelSize2.component2();
        Rect $this$component1$iv = rect = drawable.getBounds();
        boolean $i$f$component1 = false;
        int n = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int n2 = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int n3 = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        Bitmap bitmap3 = this.bitmapPool.get((int)width, height, safeConfig);
        Drawable drawable2 = drawable;
        boolean bl = false;
        boolean bl2 = false;
        Drawable $this$apply = drawable2;
        boolean bl3 = false;
        $this$apply.setBounds(0, 0, (int)width, height);
        $this$apply.draw(new Canvas(bitmap3));
        $this$apply.setBounds((int)oldLeft, (int)oldTop, (int)oldRight, oldBottom);
        return bitmap3;
    }

    private final boolean shouldConvertToBitmap(Drawable drawable) {
        return drawable instanceof VectorDrawableCompat || Build.VERSION.SDK_INT > 21 && drawable instanceof VectorDrawable;
    }

    public DrawableDecoderService(@NotNull Context context, @NotNull BitmapPool bitmapPool) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bitmapPool, (String)"bitmapPool");
        this.context = context;
        this.bitmapPool = bitmapPool;
    }
}

