/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 E2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001EB+\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0017J\b\u0010 \u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\rH\u0016J \u0010+\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\tH\u0016J\u0012\u00101\u001a\u00020\u00192\b\u00102\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\tH\u0017J\u0012\u00105\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u000107H\u0017J\u0012\u00108\u001a\u00020\u00192\b\u00109\u001a\u0004\u0018\u00010:H\u0017J\u0012\u0010;\u001a\u00020\u00192\b\u0010<\u001a\u0004\u0018\u00010=H\u0017J\b\u0010\u0004\u001a\u00020\u0019H\u0016J\b\u0010>\u001a\u00020\u0019H\u0016J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\rH\u0016J\u0018\u0010@\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-H\u0016J\u001d\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020(H\u0001\u00a2\u0006\u0002\bDR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "start", "end", "scale", "Lcoil/size/Scale;", "duration", "", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;I)V", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "getEnd", "()Landroid/graphics/drawable/Drawable;", "height", "isDone", "", "isRunning", "maxAlpha", "startTimeMillis", "", "width", "clearAnimationCallbacks", "", "draw", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getColorFilter", "Landroid/graphics/ColorFilter;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "markDone", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "registerAnimationCallback", "callback", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "setAlpha", "alpha", "setColorFilter", "colorFilter", "setTint", "tintColor", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "stop", "unregisterAnimationCallback", "unscheduleDrawable", "updateBounds", "drawable", "targetBounds", "updateBounds$coil_base_release", "Companion", "coil-base_release"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable2Compat {
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private final int width;
    private final int height;
    private long startTimeMillis;
    private int maxAlpha;
    private boolean isDone;
    private boolean isRunning;
    private Drawable start;
    @NotNull
    private final Drawable end;
    private final Scale scale;
    private final int duration;
    public static final int DEFAULT_DURATION = 100;
    public static final Companion Companion = new Companion(null);

    public void draw(@NotNull Canvas canvas) {
        boolean isDone;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.isRunning || this.isDone) {
            this.end.setAlpha(this.maxAlpha);
            this.end.draw(canvas);
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.duration;
        boolean bl = isDone = percent >= 1.0;
        if (!isDone) {
            Drawable drawable = this.start;
            if (drawable != null) {
                Drawable drawable2 = drawable;
                boolean bl2 = false;
                boolean bl3 = false;
                Drawable $this$apply = drawable2;
                boolean bl4 = false;
                $this$apply.setAlpha(this.maxAlpha);
                $this$apply.draw(canvas);
            }
        }
        this.end.setAlpha((int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha));
        this.end.draw(canvas);
        if (isDone) {
            this.markDone();
        } else {
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.maxAlpha;
    }

    public void setAlpha(int alpha) {
        int n = alpha;
        n = 0 <= n && 255 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid alpha: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    public int getOpacity() {
        Drawable start = this.start;
        return this.isRunning && start != null ? Drawable.resolveOpacity((int)start.getOpacity(), (int)this.end.getOpacity()) : this.end.getOpacity();
    }

    @RequiresApi(value=21)
    @Nullable
    public ColorFilter getColorFilter() {
        return this.end.getColorFilter();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setColorFilter(colorFilter);
        }
        this.end.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Drawable drawable = this.start;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable2;
            boolean bl3 = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
        this.updateBounds$coil_base_release(this.end, bounds);
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.scheduleSelf(what, when);
    }

    @RequiresApi(value=21)
    public void setTint(int tintColor) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTint(tintColor);
        }
        this.end.setTint(tintColor);
    }

    @RequiresApi(value=21)
    public void setTintList(@Nullable ColorStateList tint) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintList(tint);
        }
        this.end.setTintList(tint);
    }

    @RequiresApi(value=21)
    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintMode(tintMode);
        }
        this.end.setTintMode(tintMode);
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintBlendMode(blendMode);
        }
        this.end.setTintBlendMode(blendMode);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        Drawable drawable;
        Drawable drawable2 = this.start;
        if (!(drawable2 instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable = (Animatable)drawable2;
        if (animatable != null) {
            animatable.start();
        }
        if (!((drawable = this.end) instanceof Animatable)) {
            drawable = null;
        }
        Animatable animatable2 = (Animatable)drawable;
        if (animatable2 != null) {
            animatable2.start();
        }
        if (this.isRunning || this.isDone) {
            return;
        }
        this.isRunning = true;
        this.startTimeMillis = SystemClock.uptimeMillis();
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        Drawable drawable;
        Drawable drawable2 = this.start;
        if (!(drawable2 instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable = (Animatable)drawable2;
        if (animatable != null) {
            animatable.stop();
        }
        if (!((drawable = this.end) instanceof Animatable)) {
            drawable = null;
        }
        Animatable animatable2 = (Animatable)drawable;
        if (animatable2 != null) {
            animatable2.stop();
        }
        if (!this.isDone) {
            this.markDone();
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    @VisibleForTesting
    public final void updateBounds$coil_base_release(@NotNull Drawable drawable, @NotNull Rect targetBounds) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)targetBounds, (String)"targetBounds");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            drawable.setBounds(targetBounds);
            return;
        }
        int targetWidth = targetBounds.width();
        int targetHeight = targetBounds.height();
        float multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int dx = MathKt.roundToInt((float)(((float)targetWidth - multiplier * (float)width) / (float)2));
        int dy = MathKt.roundToInt((float)(((float)targetHeight - multiplier * (float)height) / (float)2));
        int left = targetBounds.left + dx;
        int top = targetBounds.top + dy;
        int right = targetBounds.right - dx;
        int bottom = targetBounds.bottom - dy;
        drawable.setBounds(left, top, right, bottom);
    }

    private final void markDone() {
        this.isDone = true;
        this.isRunning = false;
        this.start = null;
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationEnd((Drawable)this);
        }
    }

    @NotNull
    public final Drawable getEnd() {
        return this.end;
    }

    public CrossfadeDrawable(@Nullable Drawable start, @NotNull Drawable end, @NotNull Scale scale, int duration) {
        int n;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        this.start = start;
        this.end = end;
        this.scale = scale;
        this.duration = duration;
        CrossfadeDrawable crossfadeDrawable = this;
        int n2 = 0;
        crossfadeDrawable.callbacks = list = (List)new ArrayList();
        Drawable drawable = this.start;
        n2 = drawable != null ? drawable.getIntrinsicWidth() : -1;
        int n3 = this.end.getIntrinsicWidth();
        crossfadeDrawable = this;
        boolean bl = false;
        crossfadeDrawable.width = n = Math.max(n2, n3);
        Drawable drawable2 = this.start;
        n2 = drawable2 != null ? drawable2.getIntrinsicHeight() : -1;
        n3 = this.end.getIntrinsicHeight();
        crossfadeDrawable = this;
        bl = false;
        crossfadeDrawable.height = n = Math.max(n2, n3);
        this.maxAlpha = 255;
        Drawable drawable3 = this.start;
        if (drawable3 != null) {
            drawable3.setCallback((Drawable.Callback)this);
        }
        this.end.setCallback((Drawable.Callback)this);
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(drawable, drawable2, scale, n);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "()V", "DEFAULT_DURATION", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

