/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.webkit.MimeTypeMap;
import coil.bitmappool.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.HttpUrlFetcher;
import coil.fetch.SourceResult;
import coil.network.HttpException;
import coil.size.Size;
import coil.util.ContinuationCallback;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcoil/fetch/HttpUrlFetcher;", "Lcoil/fetch/Fetcher;", "Lokhttp3/HttpUrl;", "callFactory", "Lokhttp3/Call$Factory;", "(Lokhttp3/Call$Factory;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmappool/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;Lokhttp3/HttpUrl;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMimeType", "", "body", "Lokhttp3/ResponseBody;", "key", "Companion", "coil-base_release"})
public final class HttpUrlFetcher
implements Fetcher<HttpUrl> {
    private final Call.Factory callFactory;
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final CacheControl CACHE_CONTROL_FORCE_NETWORK_NO_CACHE;
    private static final CacheControl CACHE_CONTROL_NO_NETWORK_NO_CACHE;
    public static final Companion Companion;

    @Override
    @NotNull
    public String key(@NotNull HttpUrl data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.toString()");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull HttpUrl data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        if (!($completion instanceof fetch.1)) ** GOTO lbl-1000
        var20_6 = $completion;
        if ((var20_6.label & -2147483648) != 0) {
            var20_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ HttpUrlFetcher this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                boolean Z$0;
                boolean Z$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch(null, null, null, null, (Continuation<? super FetchResult>)this);
                }
                {
                    this.this$0 = httpUrlFetcher;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var21_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = new Request.Builder().url(data).headers(options.getHeaders());
                networkRead = options.getNetworkCachePolicy().getReadEnabled();
                diskRead = options.getDiskCachePolicy().getReadEnabled();
                if (!networkRead && diskRead) {
                    request.cacheControl(CacheControl.FORCE_CACHE);
                } else if (networkRead && !diskRead) {
                    if (options.getDiskCachePolicy().getWriteEnabled()) {
                        request.cacheControl(CacheControl.FORCE_NETWORK);
                    } else {
                        request.cacheControl(HttpUrlFetcher.CACHE_CONTROL_FORCE_NETWORK_NO_CACHE);
                    }
                } else if (!networkRead && !diskRead) {
                    request.cacheControl(HttpUrlFetcher.CACHE_CONTROL_NO_NETWORK_NO_CACHE);
                }
                v0 = this.callFactory.newCall(request.build());
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"callFactory.newCall(request.build())");
                $this$await$iv = v0;
                $i$f$await = false;
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = pool;
                $continuation.L$2 = data;
                $continuation.L$3 = size;
                $continuation.L$4 = options;
                $continuation.L$5 = request;
                $continuation.Z$0 = networkRead;
                $continuation.Z$1 = diskRead;
                $continuation.L$6 = $this$await$iv;
                $continuation.label = 1;
                uCont$iv$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv$iv = false;
                cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv$iv), 1);
                continuation$iv = (CancellableContinuation)cancellable$iv$iv;
                $i$a$-suspendCancellableCoroutine-ExtensionsKt$await$2$iv = false;
                callback$iv = new ContinuationCallback($this$await$iv, (CancellableContinuation<? super Response>)continuation$iv);
                $this$await$iv.enqueue((Callback)callback$iv);
                continuation$iv.invokeOnCancellation((Function1)callback$iv);
                v1 = cancellable$iv$iv.getResult();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v2 = v1;
                if (v1 == var21_8) {
                    return var21_8;
                }
                ** GOTO lbl77
            }
            case 1: {
                $this$await$iv = (Call)$continuation.L$6;
                diskRead = $continuation.Z$1;
                networkRead = $continuation.Z$0;
                request = (Request.Builder)$continuation.L$5;
                options = (Options)$continuation.L$4;
                size = (Size)$continuation.L$3;
                data = (HttpUrl)$continuation.L$2;
                pool = (BitmapPool)$continuation.L$1;
                this = (HttpUrlFetcher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl77:
                // 2 sources

                response = (Response)v2;
                if (!response.isSuccessful()) {
                    throw (Throwable)new HttpException(response);
                }
                var11_17 = response.body();
                var12_18 = false;
                var13_20 = false;
                if (var11_17 == null) {
                    $i$a$-checkNotNull-HttpUrlFetcher$fetch$body$1 = false;
                    var13_21 = "Null response body!";
                    throw (Throwable)new IllegalStateException(var13_21.toString());
                }
                body = var11_17;
                v3 = body.source();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"body.source()");
                return new SourceResult(v3, this.getMimeType(data, body), response.cacheResponse() != null ? DataSource.DISK : DataSource.NETWORK);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getMimeType(HttpUrl data, ResponseBody body) {
        String string;
        String rawContentType;
        MediaType mediaType = body.contentType();
        String string2 = rawContentType = mediaType != null ? mediaType.toString() : null;
        if (rawContentType == null || StringsKt.startsWith$default((String)rawContentType, (String)MIME_TYPE_TEXT_PLAIN, (boolean)false, (int)2, null)) {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            Intrinsics.checkExpressionValueIsNotNull((Object)mimeTypeMap, (String)"MimeTypeMap.getSingleton()");
            string = ExtensionsKt.getMimeTypeFromUrl(mimeTypeMap, data.toString());
            if (string == null) {
                string = rawContentType;
            }
        } else {
            string = rawContentType;
        }
        return string;
    }

    public HttpUrlFetcher(@NotNull Call.Factory callFactory) {
        Intrinsics.checkParameterIsNotNull((Object)callFactory, (String)"callFactory");
        this.callFactory = callFactory;
    }

    static {
        Companion = new Companion(null);
        CACHE_CONTROL_FORCE_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().noStore().build();
        CACHE_CONTROL_NO_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().onlyIfCached().build();
    }

    @Override
    public boolean handles(@NotNull HttpUrl data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Fetcher.DefaultImpls.handles(this, data);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/fetch/HttpUrlFetcher$Companion;", "", "()V", "CACHE_CONTROL_FORCE_NETWORK_NO_CACHE", "Lokhttp3/CacheControl;", "kotlin.jvm.PlatformType", "CACHE_CONTROL_NO_NETWORK_NO_CACHE", "MIME_TYPE_TEXT_PLAIN", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

