/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import coil.bitmappool.BitmapPool;
import coil.decode.DataSource;
import coil.decode.DrawableDecoderService;
import coil.decode.Options;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import coil.util.ContextsKt;
import coil.util.ExtensionsKt;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcoil/fetch/ResourceUriFetcher;", "Lcoil/fetch/Fetcher;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "drawableDecoder", "Lcoil/decode/DrawableDecoderService;", "(Landroid/content/Context;Lcoil/decode/DrawableDecoderService;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmappool/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;Landroid/net/Uri;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "key", "", "throwInvalidUriException", "", "Companion", "coil-base_release"})
public final class ResourceUriFetcher
implements Fetcher<Uri> {
    private final Context context;
    private final DrawableDecoderService drawableDecoder;
    private static final String MIME_TYPE_XML = "text/xml";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
    }

    @Override
    @NotNull
    public String key(@NotNull Uri data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        StringBuilder stringBuilder = new StringBuilder().append(data).append('-');
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"context.resources.configuration");
        return stringBuilder.append(ExtensionsKt.getNightMode(configuration)).toString();
    }

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull Uri data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        CharSequence path;
        boolean $i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22;
        String it;
        String string;
        block9: {
            block8: {
                string = data.getAuthority();
                if (string == null) break block8;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                it = string2;
                $i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22 = false;
                String string3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                CharSequence charSequence = string3;
                boolean bl3 = false;
                string = Boxing.boxBoolean((!StringsKt.isBlank((CharSequence)charSequence) ? 1 : 0) != 0) != false ? string2 : null;
                if (string != null) break block9;
            }
            Void void_ = this.throwInvalidUriException(data);
            throw null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.authority?.takeIf {\u2026InvalidUriException(data)");
        String packageName = string;
        List list = data.getPathSegments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"data.pathSegments");
        Object object = (String)CollectionsKt.lastOrNull((List)list);
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            Void void_ = this.throwInvalidUriException(data);
            throw null;
        }
        int resId = (Integer)object;
        Resources resources = this.context.getPackageManager().getResourcesForApplication(packageName);
        it = new TypedValue();
        $i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22 = false;
        int n = 0;
        String $this$apply = it;
        boolean bl = false;
        resources.getValue(resId, (TypedValue)$this$apply, true);
        CharSequence charSequence = path = ((TypedValue)it).string;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"path");
        CharSequence $i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22 = charSequence;
        n = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n2 = $i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22.length();
        boolean bl4 = false;
        String entryName = ((Object)$i$a$-takeIf-ResourceUriFetcher$fetch$packageName$22.subSequence(n, n2)).toString();
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        Intrinsics.checkExpressionValueIsNotNull((Object)mimeTypeMap, (String)"MimeTypeMap.getSingleton()");
        String mimeType = ExtensionsKt.getMimeTypeFromUrl(mimeTypeMap, entryName);
        if (Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_XML)) {
            Drawable drawable;
            if (Intrinsics.areEqual((Object)packageName, (Object)this.context.getPackageName())) {
                drawable = ContextsKt.getDrawableCompat(this.context, resId);
            } else {
                Resources resources2 = resources;
                Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
                drawable = ContextsKt.getXmlDrawableCompat(this.context, resources2, resId);
            }
            Drawable drawable2 = drawable;
            fetchResult = new DrawableResult(this.drawableDecoder.convertIfNecessary(drawable2, size, options.getConfig()), false, DataSource.MEMORY);
        } else {
            InputStream inputStream = resources.openRawResource(resId);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resources.openRawResource(resId)");
            fetchResult = new SourceResult(Okio.buffer((Source)Okio.source((InputStream)inputStream)), mimeType, DataSource.MEMORY);
        }
        return fetchResult;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw (Throwable)new IllegalStateException("Invalid android.resource URI: " + data);
    }

    public ResourceUriFetcher(@NotNull Context context, @NotNull DrawableDecoderService drawableDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)drawableDecoder, (String)"drawableDecoder");
        this.context = context;
        this.drawableDecoder = drawableDecoder;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/fetch/ResourceUriFetcher$Companion;", "", "()V", "MIME_TYPE_XML", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

