/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.collection.LruCache;
import coil.memory.BitmapReferenceCounter;
import coil.memory.MemoryCache;
import coil.memory.RealMemoryCache;
import coil.util.CoilLogger;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005*\u0001\b\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcoil/memory/RealMemoryCache;", "Lcoil/memory/MemoryCache;", "referenceCounter", "Lcoil/memory/BitmapReferenceCounter;", "maxSize", "", "(Lcoil/memory/BitmapReferenceCounter;I)V", "cache", "coil/memory/RealMemoryCache$cache$1", "Lcoil/memory/RealMemoryCache$cache$1;", "clearMemory", "", "get", "Lcoil/memory/MemoryCache$Value;", "key", "", "set", "value", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "trimMemory", "level", "Companion", "coil-base_release"})
final class RealMemoryCache
implements MemoryCache {
    private final cache.1 cache;
    private final BitmapReferenceCounter referenceCounter;
    private static final String TAG = "RealMemoryCache";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public MemoryCache.Value get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (MemoryCache.Value)this.cache.get(key);
    }

    @Override
    public void set(@NotNull String key, @NotNull Bitmap value, boolean isSampled) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int size = ExtensionsKt.getAllocationByteCountCompat(value);
        if (size > this.maxSize()) {
            this.cache.remove(key);
            return;
        }
        this.referenceCounter.increment(value);
        this.cache.put(key, new MemoryCache.Value(value, isSampled, size));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public int maxSize() {
        return this.cache.maxSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearMemory() {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var6_4 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "clearMemory";
            Log.println((int)n, (String)var6_4, (String)string2);
        }
        this.cache.trimToSize(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trimMemory(int level) {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var7_6 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "trimMemory, level=" + level;
            Log.println((int)n, (String)var7_6, (String)string2);
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            int n = level;
            if (10 <= n && 20 > n) {
                this.cache.trimToSize(this.size() / 2);
            }
        }
    }

    public RealMemoryCache(@NotNull BitmapReferenceCounter referenceCounter, int maxSize) {
        Intrinsics.checkParameterIsNotNull((Object)referenceCounter, (String)"referenceCounter");
        this.referenceCounter = referenceCounter;
        this.cache = new LruCache<String, MemoryCache.Value>(this, maxSize, maxSize){
            final /* synthetic */ RealMemoryCache this$0;
            final /* synthetic */ int $maxSize;

            protected void entryRemoved(boolean evicted, @NotNull String key, @NotNull MemoryCache.Value oldValue, @Nullable MemoryCache.Value newValue) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
                RealMemoryCache.access$getReferenceCounter$p(this.this$0).decrement(oldValue.getBitmap());
            }

            protected int sizeOf(@NotNull String key, @NotNull MemoryCache.Value value) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getSize();
            }
            {
                this.this$0 = $outer;
                this.$maxSize = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ BitmapReferenceCounter access$getReferenceCounter$p(RealMemoryCache $this) {
        return $this.referenceCounter;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/RealMemoryCache$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

