/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Objects;
import org.jose4j.jwk.JsonWebKeySet;

public final class JwtIssuerValue
extends AuthValue {
    private final JsonWebKeySet jwks;

    public JwtIssuerValue(@JsonProperty(value="keys") JsonWebKeySet jwks) {
        this.jwks = Objects.requireNonNull(jwks, "Argument `jwks` must not be null");
    }

    @JsonProperty(value="keys")
    public JsonWebKeySet keys() {
        return this.jwks;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.JWT_ISSUER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JwtIssuerValue)) {
            return false;
        }
        return this.jwks.getJsonWebKeys().equals(((JwtIssuerValue)o).jwks.getJsonWebKeys());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.jwks);
    }

    public String toString() {
        return String.format("JwtIssuerValue{\n\tkeys=%s\n}", this.jwks.getJsonWebKeys().toString());
    }
}

